package io.agora.push.platform.fcm;

import android.content.Context;
import android.text.TextUtils;

import io.agora.Error;
import io.agora.push.PushConfig;
import io.agora.push.PushHelper;
import io.agora.push.PushType;
import io.agora.push.PushListener;
import io.agora.push.platform.IPush;

public class EMFCMPush extends IPush {
    private static final String TAG = "EMFCMPush";

    @Override
    public PushType getPushType() {
        return PushType.FCM;
    }

    @Override
    public void onRegister(Context context, PushConfig config, PushListener pushListener) {
        boolean support = true;
        if(pushListener != null) {
            support = pushListener.isSupportPush(getPushType(), config);
        }
        if (!support) {
            PushHelper.getInstance().onErrorResponse(getPushType(), Error.PUSH_NOT_SUPPORT);
        } else { // fcm推送为自动初始化，如果初始化后获取token成功的时候环信账号还没有登录成功，则会把token存储到本地。
            String storedToken = PushHelper.getInstance().getFCMPushToken();
            if(TextUtils.isEmpty(storedToken) && pushListener != null) {
                storedToken = pushListener.getPushToken(getPushType(), config);
                if(!TextUtils.isEmpty(storedToken)) {
                    try {
                        PushHelper.getInstance().setFCMPushToken(storedToken);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!TextUtils.isEmpty(storedToken)) {
                PushHelper.getInstance().onReceiveToken(getPushType(), storedToken);
            }
        }
    }

    @Override
    public void onUnregister(Context context) {
    }

    @Override
    public String onGetNotifierName(PushConfig config) {
        return config.getFcmSenderId();
    }
}
