/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package io.agora.exceptions;

import io.agora.chat.adapter.EMAError;

/**
 * \~english
 * The exception class that inherits from `Exception`.
 */
public class ChatException extends Exception {

	protected int errorCode = -1;
	protected String desc = "";
	
    /** Default for non-checking. */
    private static final long serialVersionUID = 1L;
   
    public ChatException() {
        super();
    }
    
    /**
     * \~english
     * Constructs an exception with the given description.
     * @param desc The exception description.
     */
    public ChatException(String desc) {
        super(desc);
    }
    
    public ChatException(EMAError error) {
    	super(error.errMsg());
    	errorCode = error.errCode();
        desc = error.errMsg();
    }
    
    /**
     * \~english
     * Constructs an exception with the given description and exception cause.
     * @param desc The exception description.
     * @param cause The exception cause.
     */
    public ChatException(String desc, Throwable cause) {
        super(desc);
        super.initCause(cause);
    }

    /**
     * \~english
     * Constructs an exception with the given description and error code.
     * @param errorCode The error code.
     * @param desc The exception description.
     */
    public ChatException(int errorCode, String desc){
    	 super(desc);
    	 this.errorCode = errorCode;
    	 this.desc = desc;
    }

    /**
     * \~english
     * Gets the error code.
     * @return  The error code.
     */
	public int getErrorCode() {
		return errorCode;
	}

    /**
     * \~english
     * Gets the exception description.
     * @return  The exception description.
     */
	public String getDescription() {
	    return this.desc;
	}

    /**
     * \~english
     * Sets the error code.
     * @param errorCode The error code to set.
     */
	public void setErrorCode(int errorCode) {
		this.errorCode = errorCode;
	}
    
    
}
