/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package io.agora.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;

import io.agora.chat.adapter.message.EMAMessageBody;
import io.agora.chat.adapter.message.EMAVoiceMessageBody;
import io.agora.util.FileHelper;
import io.agora.util.EMLog;

import java.io.File;

/**
 * \~english
 * The voice message body.
 *
 * ```java
 *     VoiceMessageBody body = new VoiceMessageBody(voiceFile, length);
 * ```
 */
public class VoiceMessageBody extends FileMessageBody implements Parcelable {

	/**
     * \~english
     * Creates a voice message body.
     *
     * @param voiceFile The path of the voice file.
     * @param duration  The voice duration in seconds.
     */
    public VoiceMessageBody(File voiceFile, int duration) {
        //mimeType = MimeType.VOICE;
    	this(Uri.fromFile(voiceFile), duration);
    }

	/**
     * \~english
     * Creates a voice message body.
     *
     * @param voiceFile The URI of the voice file.
     * @param duration  The voice duration in seconds.
     *
     */
    public VoiceMessageBody(Uri voiceFile, int duration) {
        //mimeType = MimeType.VOICE;
    	super(voiceFile, EMAMessageBody.EMAMessageBodyType_VOICE);
    	((EMAVoiceMessageBody)emaObject).setDuration(duration);
    	((EMAVoiceMessageBody)emaObject).setDisplayName(FileHelper.getInstance().getFilename(voiceFile));
        EMLog.d("voicemsg", "create voice, message body for:" + voiceFile);
    }

    public VoiceMessageBody(EMAVoiceMessageBody body) {
    	super(body);
	}

    /**
     * create voice message body from incoming XMPP message json
     */
    VoiceMessageBody(String fileName, String remoteUrl, int length) {
    	super(fileName, EMAMessageBody.EMAMessageBodyType_VOICE);
        ((EMAVoiceMessageBody)emaObject).setLocalPath(fileName);
        ((EMAVoiceMessageBody)emaObject).setRemotePath(remoteUrl);
        ((EMAVoiceMessageBody)emaObject).setDuration(length);
    }
    
    /**
     * \~english
     * Gets the voice duration.
     *
     * @return  The voice duration in seconds.
     */
    public int getLength() {
        return ((EMAVoiceMessageBody)emaObject).duration();
    }

    /**
     * \~english
     * Gets the size of the voice file.
     * @return  The size of the voice file in bytes.
     */
    public long getFileSize() {
        return ((EMAVoiceMessageBody)emaObject).fileLength();
    }
    
    public String toString() {
        return "voice:" + ((EMAVoiceMessageBody)emaObject).displayName() + ",localurl:" + ((EMAVoiceMessageBody)emaObject).getLocalUrl() + ""
                + ",remoteurl:" + ((EMAVoiceMessageBody)emaObject).getRemoteUrl() + ",length:" + ((EMAVoiceMessageBody)emaObject).duration();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        //members from FileMessageBody
        dest.writeString(((EMAVoiceMessageBody)emaObject).displayName());
        dest.writeString(((EMAVoiceMessageBody)emaObject).getLocalUrl());
        dest.writeString(((EMAVoiceMessageBody)emaObject).getRemoteUrl());
        dest.writeInt(((EMAVoiceMessageBody)emaObject).duration());
    }
    
    public static final Parcelable.Creator<VoiceMessageBody> CREATOR
            = new Parcelable.Creator<VoiceMessageBody>() {
        public VoiceMessageBody createFromParcel(Parcel in) {
            return new VoiceMessageBody(in);
        }

        public VoiceMessageBody[] newArray(int size) {
            return new VoiceMessageBody[size];
        }
    };

    private VoiceMessageBody(Parcel in) {
        //members from FileMessageBody
    	super("", EMAMessageBody.EMAMessageBodyType_VOICE);
    	((EMAVoiceMessageBody)emaObject).setDisplayName(in.readString());
    	((EMAVoiceMessageBody)emaObject).setLocalPath(in.readString());
    	((EMAVoiceMessageBody)emaObject).setRemotePath(in.readString());
    	((EMAVoiceMessageBody)emaObject).setDuration(in.readInt());
    }
}
