package io.agora.chat;

/**
     * \~english
     * The user attribute class that contains user attributes.
     */
public class UserInfo {
    /**
     * \~english
     * The user's nickname.
     */
    private String nickname;

    /**
     * \~english
     * The avatar URL of the user.
     */
    private String avatarUrl;

     /**
     * \~english
     * The email address of the user.
     */
    private String email;

    /**
     * \~english
     * The phone number of the user.
     */
    private String phoneNumber;

    /**
     * \~english
     * The user's gender. The value can only be 0, 1, or 2. 0: default; 1: male; 2: female. Other values are invalid.
     */
    private int gender = 0;

    /**
     * \~english
     * The user's signature.
     */
    private String signature;

    /**
     * \~english
     * The user's birthday.
     */
    private String birth;

    /**
     * \~english
     * The user ID.
     */
    private String userId;

    /**
     * \~english
     * The user's extension information. You can set it to an empty string or type custom information and encapsulate them as a JSON string.
     */
    private String ext;

    public UserInfo(){
    }

    public enum UserInfoType {
    /**
     * \~english
     * The user's nickname.
     */
        NICKNAME(0,"nickname"),
        
      /**
     * \~english
     * The avatar URL of the user.
     */   
        AVATAR_URL(1,"avatarurl"),

      /**
     * \~english
     * The email address of the user.
     */  
        EMAIL(2,"mail"),

      /**
     * \~english
     * The phone number of the user.
     */  
        PHONE(3,"phone"),

     /**
     * \~english
     * The user's gender.
     */   
        GENDER(4,"gender"),

    /**
     * \~english
     * The user's signature.
     */
        SIGN(5,"sign"),

      /**
     * \~english
     * The user's birthday.
     */  
        BIRTH(6,"birth"),

     /**
     * \~english
     * The user's extension information. You can set it to an empty string or type custom information and encapsulate them as a JSON string.
     */   
        EXT(100,"ext");

        private int value;
        private String desc;

        public int getValue() {
            return value;
        }
        public void setValue(int value) {
            this.value = value;
        }
        public String getDesc() {
            return desc;
        }
        public void setDesc(String desc) {
            this.desc = desc;
        }
        private UserInfoType(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }
    }

    /**
     * \~english
     * Gets the user's nickname.
     * @return  The user's nickname.
     * @deprecated Deprecated. Please use {@link UserInfo#getNickname()} instead.
     */
    @Deprecated
    public String getNickName() {
        return getNickname();
    }
    /**
     * \~english
     * Gets the user's nickname.
     * @return  The user's nickname.
     */
    public String getNickname() {
        return nickname;
    }

    /**
     * \~english
     * Sets the user's nickname.
     * @param nickname The user's nickname.
     * @deprecated Deprecated. Please use {@link UserInfo#setNickname(java.lang.String)} instead.
     */
    @Deprecated
    public void setNickName(String nickname) {
        setNickname(nickname);
    }

    /**
     * \~english
     * Sets the user's nickname.
     * @param nickname The user's nickname.
     */
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }
    /**
     * \~english
     * Gets the user's avatar URL.
     * @return  The user's avatar URL.
     */
    public String getAvatarUrl() {
        return avatarUrl;
    }

    /**
     * \~english
     * Sets the user's avatar URL.
     * @param avatarUrl The user's avatar URL.
     */
    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    /**
     * \~english
     * Gets the user's email address.
     * @return  The user's email address.
     */
    public String getEmail() {
        return email;
    }

    /**
     * \~english
     * Sets the user's email address.
     * @param email The user's email address.
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * \~english
     * Gets the user's phone number.
     * @return  The user's phone number.
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * \~english
     * Sets the user's phone number.
     * @param phoneNumber The user's phone number.
     */
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /**
     * \~english
     * Gets the user's gender.
     * @return  The user's gender.
     */
    public int getGender() {
        return gender;
    }

    /**
     * \~english
     * Sets the user's gender.
     * @param gender The user's gender.
     */
    public void setGender(int gender) {
        this.gender = gender;
    }

    /**
     * \~english
     * Gets the user's signature.
     * @return  The user's signature.
     */
    public String getSignature() {
        return signature;
    }

    /**
     * \~english
     * Sets the user's signature.
     * @param signature The user's signature.
     */
    public void setSignature(String signature) {
        this.signature = signature;
    }

    /**
     * \~english
     * Gets the user's birthday.
     * @return  The user's birthday.
     */
    public String getBirth() {
        return birth;
    }

    /**
     * \~english
     * Sets the user's birthday.
     * @param birth The user's birthday.
     */
    public void setBirth(String birth) {
        this.birth = birth;
    }

    /**
     * \~english
     * Gets the user ID.
     * @return  The user ID.
     */
    public String getUserId() { return userId; }

    /**
     * \~english
     * Sets the user ID.
     * @param userId The user ID.
     */
    public void setUserId(String userId) { this.userId = userId;}

    /**
     * \~english
     * Gets the user's extension information.
     * @return  The user's extension information.
     */
    public String getExt() {
        return ext;
    }

    /**
     * \~english
     * Sets the user's extension information.
     * @param ext The user's extension information.
     */
    public void setExt(String ext) {
        this.ext = ext;
    }
}
