package io.agora.chat;

import io.agora.chat.adapter.EMATranslateResult;

/**
 * \~english
 * The translation entity class, which has the following attributes:
 * 
 *     msgId: The message ID.
 *     conversationId: The conversation ID.
 *     showTranslation: Whether the translation is displayed. 
 *     translateTime: The number of times the message is translated. 
 *     translations: The translation content.
 * @deprecated use {@link io.agora.chat.TextMessageBody.TranslationInfo} instead.
 */
@Deprecated
public class TranslationResult extends EMBase<EMATranslateResult>{

    public TranslationResult(String msgId) {
        emaObject = new EMATranslateResult(msgId);
    }

    public TranslationResult(EMATranslateResult result){
        emaObject = result;
    }

    /**
     * \~english
     * Gets the message ID.
     * @return  The message ID.
     */
    public String msgId() {
        return emaObject.msgId();
    }

    /**
     * \~english
     * Gets the conversation ID.
     * @return The conversation ID.
     */
    public String conversationId() {
        return emaObject.conversationId();
    }

    /**
     * \~english
     * Sets the conversation ID.
     * @param conversationId The conversation ID.
     */
    public void setConversationId(String conversationId) {
        emaObject.setConversationId(conversationId);
    }

    /**
     * \~english
     * Checks whether to display the translation.
     * @return  boolean Whether to display the translation.
     *    - `true`: Yes. 
     *    - `false`: No.
     */
    public boolean showTranslation() {
        return emaObject.showTranslation();
    }

    /**
     * \~english
     * Sets whether to display the translation.
     * @param showTranslation Whether to display the translation. 
     *    - `true`: Yes. 
     *    - `false`: No.
     */
    public void setShowTranslation(boolean showTranslation) {
        emaObject.setShowTranslation(showTranslation);
    }

    /**
     * \~english
     * Gets the number of times the message is translated.
     * @return  The number of times the message is translated.
     */
    public int translateCount() {
        return emaObject.translateTime();
    }

    /**
     * \~english
     * Sets the number of times the message is translated.
     * @param translateTime The number of times the message is translated.
     */
    public void setTranslateCount(int translateTime) {
        emaObject.setTranslateTime(translateTime);
    }

    /**
     * \~english
     * Gets the translation.
     * @return  The translation.
     */
    public String translatedText() {
        return emaObject.translations();
    }

    /**
     * \~english
     * Sets the translation.
     * @param translations The translation.
     */
    public void setTranslatedText(String translations) {
        emaObject.setTranslations(translations);
    }
}
