package io.agora.chat;

import io.agora.chat.adapter.EMASilentModeParam;

/**
 * \~english
 * Offline push Settings parameter entity class
 *
 */
public class SilentModeParam extends EMBase<EMASilentModeParam> {

    /**
     * \~english
     * Offline push DND parameter type Enumeration class.
     */
    public enum SilentModeParamType{
        REMIND_TYPE, /** \～chinese 离线推送提醒类型。 \~english  Offline push notification type. */
        SILENT_MODE_DURATION, /** \～chinese 离线推送免打扰时长。 \~english Offline push DND duration.  */
        SILENT_MODE_INTERVAL /** \～chinese 离线推送免打扰时间段。 \~english  Offline push DND period. */
    }

    /**
     * \~english
     * Have the cords structure.
     * @param paramType The parameter types.
     */
    public SilentModeParam(SilentModeParamType paramType){
        emaObject = new EMASilentModeParam();
        emaObject.setParamType(paramType.ordinal());
    }

    public SilentModeParam(EMASilentModeParam param){
        emaObject = param;
    }

    /**
     * \~english
     * Setting parameter Type.
     * @param paramType The parameter types.
     *
     */
    public SilentModeParam setParamType(SilentModeParamType paramType){
        emaObject.setParamType(paramType.ordinal());
        return this;
    }

    /**
     * \~english
     * Set the offline push notification type.
     * @param remindType Offline push notification type.
     *
     */
    public SilentModeParam setRemindType(PushManager.PushRemindType remindType){
        emaObject.setRemindType(remindType.ordinal() + 1);
        return this;
    }

    /**
     * \~english
     * Set the offline push DND duration.
     * @param silentDuration Offline push DND duration, units of minutes.
     *
     */
    public SilentModeParam setSilentModeDuration(int silentDuration){
        emaObject.setSilentDuration(silentDuration);
        return this;
    }

    /**
     * \~english
     * Set the start time of offline push DND.
     * @param startTime Do not disturb start time.
     * @param endTime Do not disturb end time.
     *
     */
    public SilentModeParam setSilentModeInterval(SilentModeTime startTime, SilentModeTime endTime){
        emaObject.setStartTime(startTime.emaObject);
        emaObject.setEndTime(endTime.emaObject);
        return this;
    }
}
