/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora.chat;

import io.agora.ValueCallBack;
import io.agora.chat.adapter.EMAPushConfigs;

/**
 * \~english
 * The push configs info class.
 */
public class PushConfigs extends EMBase<EMAPushConfigs>{

    public PushConfigs(EMAPushConfigs pushConfigs){
        emaObject = pushConfigs;
    }


    /**
     * \~english
     * Gets the push display name.
     * @return The display name for push.
     */
    public String getDisplayNickname() {
        return emaObject.getDisplayNickname();
    }

//    public void setDisplayNickname(String displayNickname) {
//        this.displayNickname = displayNickname;
//    }

    /**
     * \~english
     * Gets whether to enable offline push without disturbing.
     * Sets it by {@link PushManager#disableOfflinePush(int, int)}.
     * @return Whether to enable offline push without disturbing.
     * @deprecated Use {@link PushConfigs#silentModeEnabled()} instead.
     */
    @Deprecated
    public boolean isNoDisturbOn() {
        return silentModeEnabled();
    }
    /**
     * \~english
     * Gets whether to silent the offline push.
     * Sets it by {@link PushManager#disableOfflinePush(int, int)}.
     * @return WHether to silent the offline push.
     * @deprecated Use {@link PushManager#getSilentModeForAll(ValueCallBack)} instead.
     */
    @Deprecated
    public boolean silentModeEnabled() {
        return emaObject.isNoDisturbOn();
    }

//    public void setNoDisturbOn(boolean noDisturbOn) {
//        isNoDisturbOn = noDisturbOn;
//    }

    /**
     * \~english
     * Gets the start hour of the offline push without disturbing(24-hour clock).
     * @return The start hour of the offline push without disturbing(24-hour clock).
     * @deprecated Use {@link PushConfigs#getSilentModeStart()} instead.
     */
    @Deprecated
    public int getNoDisturbStartHour() {
        return getSilentModeStart();
    }

    /**
     * \~english
     * Gets the start hour of the offline push without disturbing.
     * @return The start hour of the offline push without disturbing.
     * @deprecated Use {@link PushManager#getSilentModeForAll(ValueCallBack)} instead.
     */
    @Deprecated
    public int getSilentModeStart() {
        return emaObject.getNoDisturbStartHour();
    }

//    public void setNoDisturbStartHour(int noDisturbStartHour) {
//        this.noDisturbStartHour = noDisturbStartHour;
//    }

    /**
     * \~english
     * Gets the end hour of the offline push without disturbing.
     * @return The end hour of the offline push without disturbing.
     * @deprecated Use {@link PushConfigs#getSilentModeEnd()} instead.
     */
    @Deprecated
    public int getNoDisturbEndHour() {
        return getSilentModeEnd();
    }

    /**
     * \~english
     * Gets the end hour of the offline push without disturbing.
     * @return The end hour of the offline push without disturbing.
     * @deprecated Use {@link PushManager#getSilentModeForAll(ValueCallBack)} instead.
     */
    @Deprecated
    public int getSilentModeEnd() {
        return emaObject.getNoDisturbEndHour();
    }

//    public void setOnDisturbEndHour(int onDisturbEndHour) {
//        this.onDisturbEndHour = onDisturbEndHour;
//    }

    /**
     * \~english
     * Gets the offline push display type.
     * @return The offline push display type.
     */
    public PushManager.DisplayStyle getDisplayStyle() {
        return PushManager.DisplayStyle.values()[emaObject.getDisplayStyle()];
    }
}
