package io.agora.chat;

import io.agora.chat.adapter.EMAMessageStatistics;

public class MessageStatistics extends EMBase<EMAMessageStatistics>{

    public MessageStatistics(EMAMessageStatistics message) {
        emaObject = message;
    }
    /**
     * \~english
     * Gets the message ID.
     *
     * @return The message ID.
     */
    public String getMsgId() {
        return emaObject.getMsgId();
    }

    /**
     * \~english
     * Gets the user ID of the message recipient.
     *
     * @return The user ID of the message recipient.
     */
    public String getTo() {
        return emaObject.getTo();
    }

    /**
     * \~english
     * Gets the user ID of the message sender.
     *
     * @return The user ID of the message sender.
     */
    public String getFrom() {
        return emaObject.getFrom();
    }

    /**
     * \~english
     * Gets the message type.
     *
     * @return The message type.
     */
    public ChatMessage.Type getType() {
        return emaObject.getType();
    }

    /**
     * \~english
     * Gets the chat type.
     *
     * @return The chat type.
     */
    public ChatMessage.ChatType getChatType() {
        return emaObject.getChatType();
    }

    /**
     * \~english
     * Gets the Unix timestamp when the server receives the message.
     *
     * The Unix timestamp is in the unit of millisecond.
     *
     * @return The Unix timestamp when the server receives the message.
     */
    public long getMsgTime() {
        return emaObject.getMsgTime();
    }

    /**
     * \~english
     * Gets the message direction:
     * - `SEND`: The message is sent from the local client.
     * - `RECEIVE`: The message is received by the local client.
     *
     * @return The message direction. See {@link io.agora.chat.ChatMessage.Direct}.
     */
    public ChatMessage.Direct direct() {
        return emaObject.direct();
    }

    /**
     * \~english
     * Gets the amount of traffic for the message body.
     *
     * The traffic is measured in bytes.
     *
     * @return The traffic for the message body.
     */
    public long getMsgSize() {
        return emaObject.getMsgSize();
    }

    /**
     * \~english
     * Gets the amount of traffic for the message attachment.
     *
     * The traffic is measured in bytes.
     *
     * @return The traffic for the message attachment.
     */
    public long getAttachmentSize() {
        return emaObject.getAttachmentSize();
    }

    /**
     * \~english
     * Gets the amount of traffic for the thumbnail.
     *
     * The traffic is measured in bytes.
     *
     * @return The traffic for the thumbnail.
     */
    public long getThumbnailSize() {
        return emaObject.getThumbnailSize();
    }

    @Override
    public String toString() {
        return "MessageStatistics{" +
                "msgId: "+getMsgId()+
                " to: "+getTo()+
                " from: "+getFrom()+
                " type: "+getType().name()+
                " chatType: "+getChatType().name()+
                " msgTime: "+getMsgTime()+
                " direct: "+direct().name()+
                " msgSize: "+getMsgSize()+
                " attachmentSize: "+getAttachmentSize()+
                " thumbnailSize: "+getThumbnailSize()+
                "}";
    }
}
