package io.agora.chat;

import io.agora.chat.adapter.EMAMessageReactionOperation;

/**
 * \~english
 * The message reaction operations entity class, which has the following attributes:
 *
 *  userId: The id of the user operating the Reaction
 *  reaction: The changed Reaction.
 *  operation: The behavior of the action message Reaction. See {@link Operation}.
 */
public class MessageReactionOperation extends EMBase<EMAMessageReactionOperation> {

    public MessageReactionOperation(EMAMessageReactionOperation operation) {
        emaObject = operation;
    }

    /**
     * \~english
     * Gets the Reaction Operator.
     * @return The reaction operator.
     */
    public String getUserId() {
        return emaObject.getUserId();
    }

    /**
     * \~english
     * Gets the changed Reaction.
     * @return The Reaction.
     */
    public String getReaction() {
        return emaObject.getReaction();
    }

    /**
     * \~english
     * Gets the Reaction Operation. See {@link Operation}.
     * @return The Reaction.
     */
    public Operation getOperation() {
        int operation = emaObject.getOperation();
        if(operation == 0) {
            return Operation.REMOVE;
        }
        return Operation.ADD;
    }

    /**
     * \~english
     * Reaction operations.
     */
    public enum Operation {
        REMOVE, ADD
    }
}
