package io.agora.chat;

import io.agora.chat.adapter.EMAGroupReadAck;

/**
 * \~english
 * Returns read recipients for group messages.
 * Calls {@link ChatManager#fetchGroupReadAcks(String, int, String)} to return the requested result, for example: 
 * ```java
 *     CursorResult<GroupReadAck> result = ChatClient.getInstance().chatManager().fetchGroupReadAcks(msgId, pageSize, startAckId);
 * ```
 */
public class GroupReadAck extends EMBase<EMAGroupReadAck> {

    EMAGroupReadAck emaObject;;

    public GroupReadAck(){
        this.emaObject = new EMAGroupReadAck();
    }

    public GroupReadAck(EMAGroupReadAck groupReadAck){
        this.emaObject = new EMAGroupReadAck(groupReadAck);
    }

    /**
     * \~english
     * Gets the read receipt ID of group messages.
     * @return  The read receipt ID.
     */
    public String getAckId() {
        return this.emaObject.getAckId();
    }

    /**
     * \~english
     * Returns the group message ID.
     * @return  The group message ID.
     */
    public String getMsgId() {
        return this.emaObject.getMsgId();
    }

    /**
     * \~english
     * Gets the ID of user who sends the read receipt.
     * @return The sender ID.
     */
    public String getFrom() {
        return this.emaObject.getFrom();
    }

    /**
     * \~english
     * Gets the read receipt extension.
     * Sends the read receipt passed as the third parameter in {@link ChatManager#ackGroupMessageRead(String, String, String)}.
     *
     * @return The read receipt extension.
     */
    public String getContent() {
        return this.emaObject.getContent();
    }

    /**
     * \~english
     * Gets the order in which read receipts of group messages are sent.
     * @return The order in which read receipts of group messages are sent.
     */
    public int getCount() {
        return this.emaObject.getCount();
    }

    /**
     * \~english
     * Gets the timestamp of sending read receipts of group messages.
     * @return The timestamp of sending read receipts of group messages.
     */
    public long getTimestamp() {
        return this.emaObject.getTimestamp();
    }

}
