package io.agora.chat;

import io.agora.chat.adapter.EMADeviceInfo;

/**
 * \~english
 * The Multi-device information.
 * You can call {@link ChatClient#getLoggedInDevicesFromServer(String, String)} to get the related information.
 */
public class DeviceInfo extends EMBase<EMADeviceInfo> {

    EMADeviceInfo emaObject;

    DeviceInfo(EMADeviceInfo emaDeviceInfo) {
        this.emaObject = emaDeviceInfo;
    }

    /**
     * \~english
     * Gets the information of the other logged in devices.
     * 
     * Through the device information, you can distinguish the device type, for example:

     * 
     * ```java
     *     String deviceResource = getResource();
     *     String deviceType = deviceResource.substring(0, deviceResource.indexOf("_"));
     *     if(deviceType.equalsIgnoreCase("ios")) {
     *         // iOS device
     *     }else if(deviceType.equalsIgnoreCase("android")) {
     *         // android device
     *     }else if(deviceType.equalsIgnoreCase("web")) {
     *         // web device
     *     }else if(deviceType.equalsIgnoreCase("win")) {
     *         // win device
     *     }else if(deviceType.equalsIgnoreCase("iMac")) {
     *         // mac device
     *     }
     * ```
     * 
     * @return     The other devices‘ information.
     */
    public String getResource() { return emaObject.getResource(); }

    /**
     * \~english
     * Gets the UUID of the device.
     * @return  The UUID of the device.

     */
    public String getDeviceUUID() { return emaObject.getDeviceUUID(); }

    /**
     * \~english
     * Gets the device model name.If the user defines the device name, the device name is the user-defined one.
     * 
     * @return  The device type. For example: "Pixel 6 Pro".
     */
    public String getDeviceName() { return emaObject.getDeviceName(); }

    /*
    public void setResource(String resource)    { emaObject.setResource(resource); }
    public void setOsType(String osType)        { emaObject.setOsType(osType); }
    public void setOsVersion(String osVersion)  { emaObject.setOsVersion(osVersion); }
    public void setDeviceUUID(String deviceUUID) { emaObject.setDeviceUUID(deviceUUID); }
    public void setDeviceName(String deviceName) { emaObject.setDeviceName(deviceName); }
    */
}
