package io.agora.chat;

import android.os.Parcel;
import android.os.Parcelable;

import io.agora.chat.adapter.message.EMACustomMessageBody;

import java.util.Map;

/**
 * \~english
 * The custom message body.
 * 
 * ```java
 *     CustomMessageBody body = new CustomMessageBody(event);
 * ```
 */
public class CustomMessageBody extends MessageBody implements Parcelable {

    public CustomMessageBody(String event) {
        emaObject = new EMACustomMessageBody(event);
    }

    CustomMessageBody(EMACustomMessageBody body) {
        this.emaObject = body;
    }

    /**
     * \~english
     * Gets the event.
     *
     * @return The event.
     */
    public String event() { return ((EMACustomMessageBody)emaObject).event();}
    /**
     * \~english
     * Sets the event.
     */
    public void setEvent(String event) {
        ((EMACustomMessageBody)emaObject).setEvent(event);
    }

    /**
     * \~english
     * Gets the params map.
     *
     * @return The Map list.
     */
    public Map<String, String> getParams() { return ((EMACustomMessageBody)emaObject).params(); }

    /**
     * \~english
     * Sets the params map.
     *
     */
    public void setParams(Map<String, String> params) {
        ((EMACustomMessageBody)emaObject).setParams(params);
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMACustomMessageBody)emaObject).event());
    }

    public static final Parcelable.Creator<CustomMessageBody> CREATOR
            = new Parcelable.Creator<CustomMessageBody>() {
        public CustomMessageBody createFromParcel(Parcel in) {
            return new CustomMessageBody(in);
        }

        public CustomMessageBody[] newArray(int size) {
            return new CustomMessageBody[size];
        }
    };

    private CustomMessageBody(Parcel in) {
        emaObject = new EMACustomMessageBody(in.readString());
    }
}
