/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora;

/**
 *  \~english
 * The callback function with a parameter.
 * For the callback function without a parameter, see {@link CallBack}.
 *
 * @param <T> value     The parameter type.
 */
public interface ValueCallBack<T>
{
	/**
     * \~english
	 * Occurs when the callback function executes successfully with a value returned.
     *
	 * @param value     The class type of value is T. 
	 * 
	 */
    void onSuccess(T value);

    /**
     * \~english
     * Occurs when the request fails.
     *
     * @param error     The error code. See {@link Error}.
     * @param errorMsg  A description of the issue that caused this call to fail.
     */
    void onError(final int error, final String errorMsg);

	/**
	 *  \~english
	 *  Occurs when the progress updates.
	 *
	 *  @param progress       The progress information.
	 *  @param status         A description of the progress. Might be an empty string "" or null if the SDK does not return the information.
	 *
	 */
	default void onProgress(int progress, String status) {}
}
