/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora;

/**
 * \~english
 * The listener when conversation changed or received the conversation receipt.
 */
public interface ConversationListener {

	/**
     * \~english
	 * Occurs when the conversation updated.
	 */
    void onConversationUpdate();

	/**
	 * \~english
	 * Occurs when received conversation read receipt.
	 *
	 * Occurs in the following scenarios:
	 * (1) The message is read by the receiver (The conversation receipt is sent).
	 * Upon receiving this event, the SDK sets the `isAcked` property of the message in the conversation to `true` in the local database.
	 * (2) In the multi-device login scenario, when one device sends a Conversation receipt,
	 * the server will set the number of unread messages to 0, and the callback occurs on the other devices.
	 * and sets the `isRead` property of the message in the conversation to `true` in the local database.
	 * @param from The user who sends the read receipt.
	 * @param to   The user who receives the read receipt.
	 */
	void onConversationRead(String from, String to);
}
