/************************************************************		
*  * EaseMob CONFIDENTIAL 		
* __________________ 		
* Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 		
*  		
* NOTICE: All information contained herein is, and remains 		
* the property of EaseMob Technologies.		
* Dissemination of this information or reproduction of this material 		
* is strictly forbidden unless prior written permission is obtained		
* from EaseMob Technologies.		
*/
package io.agora;

/**
 * \~english
 * The general callback interface.
 * 
 * For callbacks with a return value, see {@link ValueCallBack}.
 */
public interface CallBack {
    
    /**
     * \~english
     * Occurs when the method succeeds.
     */
    void onSuccess();

    /**
     * \~english
     * Occurs when an error occurs, see {@link Error}.
     *
     *  @param code           The error code.
     *  @param error          A description of the cause to the error.
     */
    void onError(int code, String error);
    
    /**
     *  \~english
     *  Occurs when the progress updates.
     *
     *  @param progress       The progress information.
     *  @param status         A description of the progress. Might be an empty string "" or null if the SDK does not return the information.
     *
     */
    default void onProgress(int progress, String status) {
    }
}
