/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustServiceCondition;
import java.util.Collections;
import java.util.List;

public class TrustServiceQualifiersKnownConsistency
implements TrustServiceCondition {
    @Override
    public boolean isConsistent(TrustServiceWrapper trustService) {
        List capturedQualifiers = trustService.getCapturedQualifierUris();
        for (String qualifier : capturedQualifiers) {
            if (this.isQualifierKnown(qualifier)) continue;
            return false;
        }
        return true;
    }

    private boolean isQualifierKnown(String qualifierUri) {
        List<String> singletonList = Collections.singletonList(qualifierUri);
        return ServiceQualification.isQcWithSSCD(singletonList) || ServiceQualification.isQcNoSSCD(singletonList) || ServiceQualification.isQcSSCDStatusAsInCert(singletonList) || ServiceQualification.isQcWithQSCD(singletonList) || ServiceQualification.isQcNoQSCD(singletonList) || ServiceQualification.isQcQSCDStatusAsInCert(singletonList) || ServiceQualification.isQcQSCDManagedOnBehalf(singletonList) || ServiceQualification.isQcForLegalPerson(singletonList) || ServiceQualification.isQcForEsig(singletonList) || ServiceQualification.isQcForEseal(singletonList) || ServiceQualification.isQcForWSA(singletonList) || ServiceQualification.isNotQualified(singletonList) || ServiceQualification.isQcStatement(singletonList);
    }
}

