/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.trust.ServiceTypeIdentifier;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServicesFilterFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class CaQcCheck
extends ChainItem<XmlValidationCertificateQualification> {
    private final List<TrustServiceWrapper> trustServices;

    public CaQcCheck(I18nProvider i18nProvider, XmlValidationCertificateQualification result, List<TrustServiceWrapper> trustServices, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.trustServices = trustServices;
    }

    @Override
    protected boolean process() {
        TrustServiceFilter filterByCaQc = TrustServicesFilterFactory.createFilterByCaQc();
        return Utils.isCollectionNotEmpty(filterByCaQc.filter(this.trustServices));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_HAS_CAQC;
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        Collection<String> stiList = this.getStis();
        MessageTag errorTag = Utils.collectionSize(stiList) == 1 ? MessageTag.QUAL_HAS_CAQC_ANS : MessageTag.QUAL_HAS_CAQC_ANS_2;
        String argument = Utils.collectionSize(stiList) == 1 ? stiList.iterator().next() : stiList.toString();
        return this.buildXmlMessage(errorTag, argument);
    }

    private Collection<String> getStis() {
        HashSet<String> identifiers = new HashSet<String>();
        for (TrustServiceWrapper trustService : this.trustServices) {
            String type = trustService.getType();
            ServiceTypeIdentifier sti = ServiceTypeIdentifier.fromUri(type);
            identifiers.add(sti != null ? sti.getShortName() : type);
        }
        return identifiers;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

