/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.KeyUsageBit;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KeyUsageCheck
extends AbstractMultiValuesCheckItem<XmlSubXCV> {
    private final CertificateWrapper certificate;
    private final Context context;
    private final SubContext subContext;

    public KeyUsageCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, Context context, SubContext subContext, MultiValuesConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.context = context;
        this.subContext = subContext;
    }

    @Override
    protected boolean process() {
        List keyUsages = this.certificate.getKeyUsages();
        List<String> kubStrings = this.toString(keyUsages);
        return this.processValuesCheck(kubStrings);
    }

    private List<String> toString(List<KeyUsageBit> keyUsages) {
        ArrayList<String> result = new ArrayList<String>();
        for (KeyUsageBit keyUsageBit : keyUsages) {
            result.add(keyUsageBit.getValue());
        }
        return result;
    }

    @Override
    protected String buildAdditionalInfo() {
        return this.i18nProvider.getMessage(MessageTag.KEY_USAGE, new Object[]{Arrays.toString(this.certificate.getKeyUsages().toArray())});
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ISCGKU;
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        if (Context.CERTIFICATE.equals((Object)this.context)) {
            return this.buildXmlMessage(MessageTag.BBB_XCV_ISCGKU_ANS_CERT, new Object[0]);
        }
        return this.buildXmlMessage(MessageTag.BBB_XCV_ISCGKU_ANS, ValidationProcessUtils.getSubContextPosition(this.subContext), ValidationProcessUtils.getContextPosition(this.context));
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubContext.CA_CERTIFICATE == this.subContext ? SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE : SubIndication.CHAIN_CONSTRAINTS_FAILURE;
    }
}

