/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.crs;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.RevocationAcceptanceChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationAcceptanceCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.AcceptableRevocationDataAvailableCheck;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CertificateRevocationSelector
extends Chain<XmlCRS> {
    protected final CertificateWrapper certificate;
    protected final Date currentTime;
    private final ValidationPolicy validationPolicy;
    protected final Map<RevocationWrapper, Boolean> revocationDataValidityMap = new HashMap<RevocationWrapper, Boolean>();
    private final Set<String> validatedTokens;
    private CertificateRevocationWrapper latestCertificateRevocation;

    public CertificateRevocationSelector(I18nProvider i18nProvider, CertificateWrapper certificate, Date currentTime, ValidationPolicy validationPolicy) {
        this(i18nProvider, certificate, currentTime, validationPolicy, new HashSet<String>());
    }

    public CertificateRevocationSelector(I18nProvider i18nProvider, CertificateWrapper certificate, Date currentTime, ValidationPolicy validationPolicy, Set<String> validatedTokens) {
        super(i18nProvider, new XmlCRS());
        this.certificate = certificate;
        this.currentTime = currentTime;
        this.validationPolicy = validationPolicy;
        this.validatedTokens = validatedTokens;
        ((XmlCRS)this.result).setId(certificate.getId());
        this.validatedTokens.add(certificate.getId());
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.CRS;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCRS> item = null;
        for (CertificateRevocationWrapper revocationWrapper : this.getCertificateRevocationData()) {
            item = this.verifyRevocationData(item, revocationWrapper);
            if (!Boolean.TRUE.equals(this.revocationDataValidityMap.get(revocationWrapper)) || this.latestCertificateRevocation != null && (revocationWrapper.getProductionDate() == null || !this.latestCertificateRevocation.getProductionDate().before(revocationWrapper.getProductionDate()))) continue;
            this.latestCertificateRevocation = revocationWrapper;
        }
        if (this.latestCertificateRevocation != null) {
            ((XmlCRS)this.result).setLatestAcceptableRevocationId(this.latestCertificateRevocation.getId());
        }
        if (item == null) {
            this.firstItem = this.acceptableRevocationDataAvailable();
            item = this.firstItem;
        } else {
            item = item.setNextItem(this.acceptableRevocationDataAvailable());
        }
    }

    protected List<CertificateRevocationWrapper> getCertificateRevocationData() {
        return this.certificate.getCertificateRevocationData();
    }

    protected ChainItem<XmlCRS> verifyRevocationData(ChainItem<XmlCRS> item, CertificateRevocationWrapper revocationWrapper) {
        XmlRAC racResult = this.getRevocationAcceptanceValidationResult(revocationWrapper);
        if (racResult != null) {
            if (item == null) {
                this.firstItem = this.revocationAcceptable(racResult);
                item = this.firstItem;
            } else {
                item = item.setNextItem(this.revocationAcceptable(racResult));
            }
        }
        this.revocationDataValidityMap.put((RevocationWrapper)revocationWrapper, this.isValid((XmlConstraintsConclusion)racResult));
        return item;
    }

    protected XmlRAC getRevocationAcceptanceValidationResult(CertificateRevocationWrapper revocationWrapper) {
        RevocationAcceptanceChecker rac = new RevocationAcceptanceChecker(this.i18nProvider, this.certificate, revocationWrapper, this.currentTime, this.validationPolicy, this.validatedTokens);
        XmlRAC racResult = (XmlRAC)rac.execute();
        ((XmlCRS)this.result).getRAC().add(racResult);
        return racResult;
    }

    public CertificateRevocationWrapper getLatestAcceptableCertificateRevocation() {
        return this.latestCertificateRevocation;
    }

    private ChainItem<XmlCRS> revocationAcceptable(XmlRAC racResult) {
        return new RevocationAcceptanceCheckerResultCheck<XmlCRS>(this.i18nProvider, (XmlCRS)this.result, racResult, this.getWarnLevelConstraint());
    }

    protected ChainItem<XmlCRS> acceptableRevocationDataAvailable() {
        return new AcceptableRevocationDataAvailableCheck<XmlCRS>(this.i18nProvider, (XmlCRS)this.result, (RevocationWrapper)this.latestCertificateRevocation, this.getFailLevelConstraint());
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (!XmlBlockType.RAC.equals((Object)constraint.getBlockType()) || !this.isValid(this.result)) {
            super.collectMessages(conclusion, constraint);
        }
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        if (!this.isValid(this.result)) {
            for (XmlRAC rac : ((XmlCRS)this.result).getRAC()) {
                super.collectAllMessages(conclusion, rac.getConclusion());
            }
        } else {
            for (XmlRAC rac : ((XmlCRS)this.result).getRAC()) {
                if (!this.isValid((XmlConstraintsConclusion)rac)) continue;
                super.collectAllMessages(conclusion, rac.getConclusion());
            }
        }
    }
}

