/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.Model;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.CheckSubXCVResult;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.ProspectiveCertificateChainCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.TrustServiceStatusCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.TrustServiceTypeIdentifierCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.SubX509CertificateValidation;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class X509CertificateValidation
extends Chain<XmlXCV> {
    private final CertificateWrapper currentCertificate;
    private final Date currentTime;
    private final Date usageTime;
    private final Context context;
    private final ValidationPolicy validationPolicy;

    public X509CertificateValidation(I18nProvider i18nProvider, CertificateWrapper currentCertificate, Date currentTime, Context context, ValidationPolicy validationPolicy) {
        this(i18nProvider, currentCertificate, currentTime, currentTime, context, validationPolicy);
    }

    public X509CertificateValidation(I18nProvider i18nProvider, CertificateWrapper currentCertificate, Date currentTime, Date usageTime, Context context, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlXCV());
        this.currentCertificate = currentCertificate;
        this.currentTime = currentTime;
        this.usageTime = usageTime;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.X509_CERTIFICATE_VALIDATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlXCV> item = this.firstItem = this.prospectiveCertificateChain();
        if (this.currentCertificate.isTrusted() || this.currentCertificate.isTrustedChain() || !this.prospectiveCertificateChainCheckEnforced()) {
            item = item.setNextItem(this.trustServiceWithExpectedTypeIdentifier());
            item = item.setNextItem(this.trustServiceWithExpectedStatus());
            SubX509CertificateValidation certificateValidation = new SubX509CertificateValidation(this.i18nProvider, this.currentCertificate, this.currentTime, this.currentTime, this.context, SubContext.SIGNING_CERT, this.validationPolicy);
            XmlSubXCV subXCV = (XmlSubXCV)certificateValidation.execute();
            ((XmlXCV)this.result).getSubXCV().add(subXCV);
            item = item.setNextItem(this.checkSubXCVResult(subXCV));
            boolean trustAnchorReached = this.currentCertificate.isTrusted();
            Model model = this.validationPolicy.getValidationModel();
            Date lastDate = Model.SHELL.equals((Object)model) ? this.currentTime : this.currentCertificate.getNotBefore();
            List certificateChainList = this.currentCertificate.getCertificateChain();
            if (Utils.isCollectionNotEmpty((Collection)certificateChainList)) {
                for (CertificateWrapper certificate : certificateChainList) {
                    if (trustAnchorReached) continue;
                    certificateValidation = new SubX509CertificateValidation(this.i18nProvider, certificate, lastDate, this.currentTime, this.context, SubContext.CA_CERTIFICATE, this.validationPolicy);
                    subXCV = (XmlSubXCV)certificateValidation.execute();
                    ((XmlXCV)this.result).getSubXCV().add(subXCV);
                    item = item.setNextItem(this.checkSubXCVResult(subXCV));
                    trustAnchorReached = certificate.isTrusted();
                    lastDate = Model.HYBRID.equals((Object)model) ? lastDate : (Model.SHELL.equals((Object)model) ? this.currentTime : certificate.getNotBefore());
                }
            }
        }
    }

    private ChainItem<XmlXCV> prospectiveCertificateChain() {
        LevelConstraint constraint = this.validationPolicy.getProspectiveCertificateChainConstraint(this.context);
        return new ProspectiveCertificateChainCheck<XmlXCV>(this.i18nProvider, (XmlXCV)this.result, this.currentCertificate, this.context, constraint);
    }

    private ChainItem<XmlXCV> trustServiceWithExpectedTypeIdentifier() {
        MultiValuesConstraint constraint = this.validationPolicy.getTrustServiceTypeIdentifierConstraint(this.context);
        return new TrustServiceTypeIdentifierCheck(this.i18nProvider, (XmlXCV)this.result, this.currentCertificate, this.usageTime, this.context, constraint);
    }

    private ChainItem<XmlXCV> trustServiceWithExpectedStatus() {
        MultiValuesConstraint constraint = this.validationPolicy.getTrustServiceStatusConstraint(this.context);
        return new TrustServiceStatusCheck(this.i18nProvider, (XmlXCV)this.result, this.currentCertificate, this.usageTime, this.context, constraint);
    }

    private ChainItem<XmlXCV> checkSubXCVResult(XmlSubXCV subXCVResult) {
        return new CheckSubXCVResult(this.i18nProvider, (XmlXCV)this.result, subXCVResult, this.getFailLevelConstraint());
    }

    private boolean prospectiveCertificateChainCheckEnforced() {
        LevelConstraint constraint = this.validationPolicy.getProspectiveCertificateChainConstraint(this.context);
        return constraint != null && Level.FAIL == constraint.getLevel();
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        for (XmlSubXCV subXCV : ((XmlXCV)this.result).getSubXCV()) {
            this.collectAllMessages(conclusion, subXCV.getConclusion());
        }
    }
}

