/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.identifier;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public abstract class Identifier
implements Serializable {
    private static final long serialVersionUID = 1440382536669604521L;
    protected static final DigestAlgorithm DIGEST_ALGO = DigestAlgorithm.SHA256;
    private final String prefix;
    private final Digest id;
    private String xmlId;

    protected Identifier(String prefix, byte[] data) {
        Objects.requireNonNull(prefix, "Prefix cannot be null!");
        Objects.requireNonNull(data, "Data binaries cannot be null!");
        this.id = new Digest(DIGEST_ALGO, this.getMessageDigest(DIGEST_ALGO).digest(data));
        this.prefix = prefix;
    }

    protected Identifier(String prefix, Digest digest) {
        Objects.requireNonNull(prefix, "Prefix cannot be null!");
        Objects.requireNonNull(digest, "Digest cannot be null!");
        this.id = digest;
        this.prefix = prefix;
    }

    protected MessageDigest getMessageDigest(DigestAlgorithm digestAlgorithm) {
        try {
            return digestAlgorithm.getMessageDigest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new DSSException("Unable to create a MessageDigest for algorithm " + digestAlgorithm, e);
        }
    }

    Digest getDigestId() {
        return this.id;
    }

    public String asXmlId() {
        if (this.xmlId == null) {
            this.xmlId = this.prefix != null ? this.prefix + this.id.getHexValue() : this.id.getHexValue();
        }
        return this.xmlId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

