/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.scope.DetachedTimestampScopeFinder;
import eu.europa.esig.dss.validation.timestamp.TimestampValidator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.tsp.TSPException;

public class DetachedTimestampValidator
extends SignedDocumentValidator
implements TimestampValidator {
    protected TimestampType timestampType;
    protected TimestampToken timestampToken;

    DetachedTimestampValidator() {
    }

    public DetachedTimestampValidator(DSSDocument timestampFile) {
        this(timestampFile, TimestampType.CONTENT_TIMESTAMP);
    }

    public DetachedTimestampValidator(DSSDocument timestampFile, TimestampType timestampType) {
        this.document = timestampFile;
        this.timestampType = timestampType;
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte((DSSDocument)dssDocument);
        if (DSSASN1Utils.isASN1SequenceTag((byte)firstByte)) {
            return DSSUtils.isTimestampToken((DSSDocument)dssDocument);
        }
        return false;
    }

    @Override
    protected void assertConfigurationValid() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
    }

    @Override
    protected List<TimestampToken> buildDetachedTimestamps() {
        return Collections.singletonList(this.getTimestamp());
    }

    @Override
    public TimestampToken getTimestamp() {
        if (this.timestampToken == null) {
            this.timestampToken = this.createTimestampToken();
            List<SignatureScope> timestampScopes = this.getTimestampScopes(this.timestampToken);
            this.timestampToken.setTimestampScopes(this.getTimestampScopes(this.timestampToken));
            this.timestampToken.getTimestampedReferences().addAll(this.getTimestampedReferences(timestampScopes));
        }
        return this.timestampToken;
    }

    protected TimestampToken createTimestampToken() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
        Objects.requireNonNull(this.document, "The timestampFile must be defined!");
        Objects.requireNonNull(this.timestampType, "The TimestampType must be defined!");
        try {
            TimestampToken newTimestampToken = new TimestampToken(DSSUtils.toByteArray((DSSDocument)this.document), this.timestampType);
            newTimestampToken.setFileName(this.document.getName());
            newTimestampToken.matchData(this.getTimestampedData());
            return newTimestampToken;
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException(String.format("Unable to create a TimestampToken. Reason : %s", e.getMessage()), e);
        }
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        if (ValidationLevel.BASIC_SIGNATURES == validationLevel) {
            throw new IllegalArgumentException("Minimal level is " + ValidationLevel.TIMESTAMPS);
        }
        super.setValidationLevel(validationLevel);
    }

    public void setTimestampedData(DSSDocument document) {
        Objects.requireNonNull(document, "The document is null");
        this.setDetachedContents(Arrays.asList(document));
    }

    @Override
    public DSSDocument getTimestampedData() {
        int size = Utils.collectionSize((Collection)this.detachedContents);
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new IllegalArgumentException("Only one detached document shall be provided for a timestamp validation!");
        }
        return (DSSDocument)this.detachedContents.iterator().next();
    }

    protected List<SignatureScope> getTimestampScopes(TimestampToken timestampToken) {
        DetachedTimestampScopeFinder timestampScopeFinder = new DetachedTimestampScopeFinder();
        timestampScopeFinder.setTimestampedData(this.getTimestampedData());
        return timestampScopeFinder.findTimestampScope(timestampToken);
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        throw new UnsupportedOperationException("getOriginalDocuments(AdvancedSignature) is not supported for DetachedTimestampValidator!");
    }
}

