/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;

public class Net {
    private static final Logger logger = Logger.getLogger(Net.class.getName());
    private static final String NO_LOCALHOST_ERROR_MESSAGE = "We could not detect if localhost is IPv4 or IPv6. Sometimes there is no entry for localhost. If 'ping localhost' does not work, it could help to add the right entry in your hosts configuration file.";
    private static final int IPV4_LENGTH = 4;

    public static boolean localhostIsIPv6() throws UnknownHostException {
        try {
            InetAddress addr = Net.getLocalHost();
            byte[] ipAddr = addr.getAddress();
            return ipAddr.length > 4;
        }
        catch (UnknownHostException ux) {
            logger.log(Level.SEVERE, NO_LOCALHOST_ERROR_MESSAGE, ux);
            throw ux;
        }
    }

    public static int freeServerPort() throws IOException {
        return Net.freeServerPort(Net.getLocalHost());
    }

    public static int freeServerPort(InetAddress hostAddress) throws IOException {
        try (ServerSocket socket = new ServerSocket(0, 0, hostAddress);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress ret = InetAddress.getLocalHost();
        if (!ret.isLoopbackAddress() || ret.getHostAddress().equals("127.0.1.1")) {
            ret = Net.localHostByName();
        }
        return ret;
    }

    public static InetAddress localHostByName() throws UnknownHostException {
        InetAddress ret = InetAddress.getByName("localhost");
        if (!ret.isLoopbackAddress()) {
            throw new IllegalArgumentException(ret.getHostAddress() + " is not a loopback address");
        }
        return ret;
    }

    public static SSLContext acceptAllSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, null);
        return sslContext;
    }
}

