/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.transitions.ImmutableStarter;
import de.flapdoodle.embed.process.transitions.RunAProcess;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.embed.process.types.ProcessConfig;
import de.flapdoodle.embed.process.types.ProcessEnv;
import de.flapdoodle.embed.process.types.ProcessWorkingDir;
import de.flapdoodle.embed.process.types.RunningProcess;
import de.flapdoodle.embed.process.types.RunningProcessFactory;
import de.flapdoodle.embed.process.types.RunningProcessImpl;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.naming.HasLabel;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.immutables.builder.Builder;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Starter<T extends RunningProcess>
extends RunAProcess<T, T>
implements HasLabel {
    @Value.Default
    public String transitionLabel() {
        return "Starter";
    }

    public abstract StateID<T> destination();

    @Override
    @Builder.Parameter
    protected abstract RunningProcessFactory<T> runningProcessFactory();

    @Override
    public Set<StateID<?>> sources() {
        return StateID.setOf((StateID[])new StateID[]{this.processWorkingDir(), this.processExecutable(), this.processConfig(), this.processEnv(), this.arguments(), this.processOutput(), this.supportConfig()});
    }

    public State<T> result(StateLookup lookup) {
        Path processWorkingDir = ((ProcessWorkingDir)lookup.of(this.processWorkingDir())).value();
        ExtractedFileSet fileSet = (ExtractedFileSet)lookup.of(this.processExecutable());
        Object arguments = ((ProcessArguments)lookup.of(this.arguments())).value();
        Object environment = ((ProcessEnv)lookup.of(this.processEnv())).value();
        ProcessConfig processConfig = (ProcessConfig)lookup.of(this.processConfig());
        ProcessOutput processOutput = (ProcessOutput)lookup.of(this.processOutput());
        SupportConfig supportConfig = (SupportConfig)lookup.of(this.supportConfig());
        try {
            T running = RunningProcess.start(this.runningProcessFactory(), processWorkingDir, fileSet.executable(), (List<String>)arguments, (Map<String, String>)environment, processConfig, processOutput, supportConfig);
            return State.of(running, (TearDown[])new TearDown[]{RunningProcess::stop});
        }
        catch (IOException ix) {
            throw new RuntimeException("could not start process", ix);
        }
    }

    public static <T extends RunningProcess> ImmutableStarter.Builder<T> with(RunningProcessFactory<T> runningProcessFactory) {
        return ImmutableStarter.builder(runningProcessFactory);
    }

    public static ImmutableStarter<RunningProcess> withDefaults() {
        return Starter.with(RunningProcessImpl::new).destination((StateID<RunningProcess>)StateID.of(RunningProcess.class)).build();
    }
}

