/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.distribution.Distribution;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PackageFinderRules {
    abstract List<PackageFinderRule> rules();

    public ImmutablePackageFinderRules with(PackageFinderRule rule) {
        return PackageFinderRules.builder().rules(this.rules()).addRules(rule).build();
    }

    @Value.Auxiliary
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        for (PackageFinderRule rule : this.rules()) {
            Optional<DistributionPackage> result;
            if (!rule.match().match(distribution) || !(result = rule.finder().packageFor(distribution)).isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public static ImmutablePackageFinderRules empty() {
        return PackageFinderRules.builder().build();
    }

    public static ImmutablePackageFinderRules.Builder builder() {
        return ImmutablePackageFinderRules.builder();
    }
}

