/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.bson;

import de.bwaldvogel.mongo.bson.Bson;
import java.util.Objects;
import java.util.UUID;

public final class LegacyUUID
implements Comparable<LegacyUUID>,
Bson {
    private static final long serialVersionUID = 1L;
    private final UUID uuid;

    public LegacyUUID(UUID uuid) {
        this.uuid = Objects.requireNonNull(uuid);
    }

    public LegacyUUID(long mostSigBits, long leastSigBits) {
        this(new UUID(mostSigBits, leastSigBits));
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static LegacyUUID fromString(String value) {
        return new LegacyUUID(UUID.fromString(value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyUUID that = (LegacyUUID)o;
        return this.getUuid().equals(that.getUuid());
    }

    public int hashCode() {
        return Objects.hash(this.getUuid());
    }

    @Override
    public int compareTo(LegacyUUID o) {
        return this.getUuid().compareTo(o.getUuid());
    }
}

