/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.AbstractMongoCollection;
import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.DatabaseResolver;
import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.backend.IndexKey;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.aggregation.Aggregation;
import de.bwaldvogel.mongo.backend.aggregation.stage.AddFieldsStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.ProjectStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.ReplaceRootStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.TerminalStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.UnsetStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.ImmutableFieldException;
import de.bwaldvogel.mongo.exception.InvalidOptionsException;
import de.bwaldvogel.mongo.exception.MergeStageNoMatchingDocumentException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.TypeMismatchException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MergeStage
extends TerminalStage {
    private static final Set<String> KNOWN_KEYS = Set.of("into", "on", "let", "whenMatched", "whenNotMatched");
    private static final Set<Class<?>> ALLOWED_STAGES_IN_PIPELINE = Set.of(AddFieldsStage.class, ProjectStage.class, UnsetStage.class, ReplaceRootStage.class);
    private final Supplier<MongoCollection<?>> targetCollectionSupplier;
    private final Set<String> joinFields;
    private final Map<String, Object> let;
    private final WhenMatched whenMatched;
    private Aggregation whenMatchedPipeline = null;
    private final WhenNotMatched whenNotMatched;

    public MergeStage(DatabaseResolver databaseResolver, MongoDatabase database, Object params) {
        if (params instanceof String) {
            params = new Document("into", params);
        }
        Document paramsDocument = (Document)params;
        for (String key : paramsDocument.keySet()) {
            if (KNOWN_KEYS.contains(key)) continue;
            throw new MongoServerError(40415, "BSON field '$merge." + key + "' is an unknown field.");
        }
        this.targetCollectionSupplier = MergeStage.getTargetCollectionSupplier(databaseResolver, database, paramsDocument);
        this.joinFields = this.getJoinFields(paramsDocument);
        if (!this.hasUniqueIndexOnJoinFields()) {
            throw new MongoServerError(51183, "Cannot find index to verify that join fields will be unique");
        }
        this.let = this.getLet(paramsDocument);
        this.whenMatched = this.getWhenMatched(paramsDocument);
        this.whenNotMatched = this.getWhenNotMatched(paramsDocument);
        if (this.whenMatched == null) {
            Collection pipeline = (Collection)paramsDocument.get("whenMatched");
            this.whenMatchedPipeline = Aggregation.fromPipeline(pipeline, databaseResolver, database, null, null);
        } else if (paramsDocument.containsKey("let")) {
            throw new MongoServerError(51199, "Cannot use 'let' variables with 'whenMatched: " + this.whenMatched + "' mode");
        }
    }

    private Map<String, Object> getLet(Document paramsDocument) {
        Object let = paramsDocument.get("let");
        if (let == null) {
            return new Document("$new", "$$ROOT");
        }
        if (!(let instanceof Document)) {
            throw new TypeMismatchException("BSON field '$merge.let' is the wrong type '" + Utils.describeType(let) + "', expected type 'object'");
        }
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : ((Document)let).entrySet()) {
            if (entry.getKey().equals("new") && !entry.getValue().equals("$$ROOT")) {
                throw new MongoServerError(51273, "'let' may not define a value for the reserved 'new' variable other than '$$ROOT'");
            }
            variables.put("$" + entry.getKey(), entry.getValue());
        }
        return variables;
    }

    private static Supplier<MongoCollection<?>> getTargetCollectionSupplier(DatabaseResolver databaseResolver, MongoDatabase database, Document paramsDocument) {
        Object into = paramsDocument.get("into");
        if (into instanceof String) {
            String collectionName = (String)into;
            return () -> MergeStage.resolveOrCreateCollection(database, collectionName);
        }
        if (into instanceof Document) {
            Document intoDocument = (Document)into;
            for (String intoKey : intoDocument.keySet()) {
                if (intoKey.equals("db") || intoKey.equals("coll")) continue;
                throw new MongoServerError(40415, "BSON field 'into." + intoKey + "' is an unknown field.");
            }
            String collectionName = (String)intoDocument.get("coll");
            return () -> {
                String databaseName = (String)intoDocument.get("db");
                MongoDatabase resolvedDatabase = databaseResolver.resolve(databaseName);
                return MergeStage.resolveOrCreateCollection(resolvedDatabase, collectionName);
            };
        }
        throw new MongoServerError(51178, "$merge 'into' field  must be either a string or an object, but found " + Utils.describeType(into));
    }

    private boolean hasUniqueIndexOnJoinFields() {
        return this.targetCollectionSupplier.get().getIndexes().stream().filter(Index::isUnique).anyMatch(this::matchesJoinFields);
    }

    private boolean matchesJoinFields(Index<?> index) {
        Set indexKeys = index.getKeys().stream().map(IndexKey::getKey).collect(Collectors.toSet());
        return indexKeys.equals(this.joinFields);
    }

    private Set<String> getJoinFields(Document paramsDocument) {
        String on = paramsDocument.getOrDefault("on", "_id");
        if (on instanceof String) {
            return Set.of(on);
        }
        if (on instanceof Collection) {
            Collection collection = (Collection)((Object)on);
            if (collection.isEmpty()) {
                throw new MongoServerError(51187, "If explicitly specifying $merge 'on', must include at least one field");
            }
            LinkedHashSet<String> joinFields = new LinkedHashSet<String>();
            for (Object value : collection) {
                if (!(value instanceof String)) {
                    throw new MongoServerError(51134, "$merge 'on' array elements must be strings, but found " + Utils.describeType(value));
                }
                String joinField = (String)value;
                if (joinFields.add(joinField)) continue;
                throw new MongoServerError(31465, "Found a duplicate field '" + joinField + "'");
            }
            return joinFields;
        }
        throw new MongoServerError(51186, "$merge 'on' field  must be either a string or an array of strings, but found " + Utils.describeType(on));
    }

    private WhenMatched getWhenMatched(Document paramsDocument) {
        String whenMatched = paramsDocument.getOrDefault("whenMatched", WhenMatched.merge.name());
        if (whenMatched instanceof String) {
            try {
                return WhenMatched.valueOf(whenMatched);
            }
            catch (IllegalArgumentException e) {
                throw new BadValueException("Enumeration value '" + whenMatched + "' for field 'whenMatched' is not a valid value.");
            }
        }
        if (whenMatched instanceof Collection) {
            Collection pipeline = (Collection)((Object)whenMatched);
            for (Object pipelineElement : pipeline) {
                if (pipelineElement instanceof Document) continue;
                throw new TypeMismatchException("Each element of the 'pipeline' array must be an object");
            }
            return null;
        }
        throw new MongoServerError(51191, "$merge 'whenMatched' field  must be either a string or an array, but found " + Utils.describeType(whenMatched));
    }

    private WhenNotMatched getWhenNotMatched(Document paramsDocument) {
        String whenNotMatched = paramsDocument.getOrDefault("whenNotMatched", WhenNotMatched.insert.name());
        if (!(whenNotMatched instanceof String)) {
            throw new TypeMismatchException("BSON field '$merge.whenNotMatched' is the wrong type '" + Utils.describeType(whenNotMatched) + "', expected type 'string'");
        }
        try {
            return WhenNotMatched.valueOf(whenNotMatched);
        }
        catch (IllegalArgumentException e) {
            throw new BadValueException("Enumeration value '" + whenNotMatched + "' for field '$merge.whenNotMatched' is not a valid value.");
        }
    }

    @Override
    public String name() {
        return "$merge";
    }

    @Override
    public void applyLast(Stream<Document> stream) {
        MongoCollection<?> collection = this.targetCollectionSupplier.get();
        this.validateWhenMatchedPipeline();
        stream.forEach(document -> {
            Document query = this.getJoinQuery((Document)document);
            Optional<Document> matchingDocument = collection.handleQueryAsStream(query).findFirst();
            if (matchingDocument.isPresent()) {
                Document existingDocument = matchingDocument.get();
                if (this.whenMatchedPipeline != null) {
                    this.let.put("$ROOT", document);
                    this.whenMatchedPipeline.setVariables(this.let);
                    List<Document> pipelineOutput = this.whenMatchedPipeline.runStages(Stream.of(existingDocument));
                    if (!pipelineOutput.isEmpty()) {
                        this.replaceDocument(collection, existingDocument, CollectionUtils.getSingleElement(pipelineOutput));
                    }
                } else {
                    switch (this.whenMatched) {
                        case merge: {
                            Document mergedDocument = existingDocument.clone();
                            mergedDocument.merge((Document)document);
                            MergeStage.assertIdHasNotChanged(existingDocument, mergedDocument);
                            this.replaceDocument(collection, existingDocument, mergedDocument);
                            break;
                        }
                        case replace: {
                            this.replaceDocument(collection, existingDocument, (Document)document);
                            break;
                        }
                        case fail: {
                            collection.addDocument((Document)document);
                            break;
                        }
                        case keepExisting: {
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("whenMatched '" + this.whenMatched + "' is not yet implemented");
                        }
                    }
                }
            } else {
                switch (this.whenNotMatched) {
                    case insert: {
                        collection.addDocument((Document)document);
                        break;
                    }
                    case discard: {
                        break;
                    }
                    case fail: {
                        throw new MergeStageNoMatchingDocumentException();
                    }
                    default: {
                        throw new UnsupportedOperationException("whenNotMatched '" + this.whenNotMatched + "' is not yet implemented");
                    }
                }
            }
        });
    }

    private void validateWhenMatchedPipeline() {
        if (this.whenMatchedPipeline == null) {
            return;
        }
        for (AggregationStage stage : this.whenMatchedPipeline.getStages()) {
            if (ALLOWED_STAGES_IN_PIPELINE.contains(stage.getClass())) continue;
            throw new InvalidOptionsException(stage.name() + " is not allowed to be used within an update");
        }
    }

    private static void assertIdHasNotChanged(Document one, Document other) {
        if (!one.get("_id").equals(other.get("_id"))) {
            throw new ImmutableFieldException("$merge failed to update the matching document, did you attempt to modify the _id or the shard key? :: caused by :: Performing an update on the path '_id' would modify the immutable field '_id'");
        }
    }

    private Document getJoinQuery(Document document) {
        Document query = new Document();
        for (String field : this.joinFields) {
            query.put(field, document.get(field));
        }
        return query;
    }

    private void replaceDocument(MongoCollection<?> collection, Document existingDocument, Document document) {
        Document documentSelector = new Document("_id", existingDocument.get("_id"));
        try {
            Document result = collection.findAndModify(new Document("query", documentSelector).append("new", false).append("upsert", false).append("update", document));
            Assert.equals(result.get("ok"), 1.0);
        }
        catch (AbstractMongoCollection.FindAndModifyPlanExecutorError e) {
            MongoServerError cause = e.getCause();
            throw new MongoServerError(cause.getCode(), cause.getCodeName(), "$merge failed to update the matching document, did you attempt to modify the _id or the shard key? :: caused by :: " + cause.getMessageWithoutErrorCode(), cause);
        }
    }

    private static MongoCollection<?> resolveOrCreateCollection(MongoDatabase database, String collectionName) {
        MongoCollection<?> collection = database.resolveCollection(collectionName, false);
        if (collection == null) {
            collection = database.createCollectionOrThrowIfExists(collectionName);
        }
        return collection;
    }

    @Override
    public boolean isModifying() {
        return true;
    }

    private static enum WhenMatched {
        replace,
        keepExisting,
        merge,
        fail;

    }

    private static enum WhenNotMatched {
        insert,
        discard,
        fail;

    }
}

