/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.backend.IndexKey;
import de.bwaldvogel.mongo.backend.KeyValue;
import de.bwaldvogel.mongo.backend.QueryOperator;
import de.bwaldvogel.mongo.backend.StreamUtils;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.bson.BsonRegularExpression;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.DuplicateKeyError;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUniqueIndex<P>
extends Index<P> {
    private static final Logger log = LoggerFactory.getLogger(AbstractUniqueIndex.class);

    protected AbstractUniqueIndex(String name, List<IndexKey> keys, boolean sparse) {
        super(name, keys, sparse);
    }

    protected abstract P removeDocument(KeyValue var1);

    protected boolean containsKey(KeyValue keyValue) {
        return this.getPosition(keyValue) != null;
    }

    protected abstract boolean putKeyPosition(KeyValue var1, P var2);

    protected abstract Iterable<Map.Entry<KeyValue, P>> getIterable();

    protected abstract P getPosition(KeyValue var1);

    private boolean isSparseAndHasNoValueForKeys(Document document) {
        return this.isSparse() && this.hasNoValueForKeys(document);
    }

    private boolean hasNoValueForKeys(Document document) {
        return this.keys().stream().noneMatch(key -> Utils.hasSubdocumentValue(document, key));
    }

    @Override
    public synchronized P remove(Document document) {
        if (this.isSparseAndHasNoValueForKeys(document)) {
            return null;
        }
        return (P)this.apply(document, this::removeDocument);
    }

    @Override
    public P getPosition(Document document) {
        return (P)this.apply(document, this::getPosition);
    }

    private P apply(Document document, Function<KeyValue, P> keyToPositionFunction) {
        Set<KeyValue> keyValues = this.getKeyValues(document);
        Set positions = keyValues.stream().map(keyToPositionFunction).filter(Objects::nonNull).collect(Collectors.toSet());
        if (positions.isEmpty()) {
            return null;
        }
        return (P)CollectionUtils.getSingleElement(positions);
    }

    @Override
    public synchronized void checkAdd(Document document, MongoCollection<P> collection) {
        if (this.isSparseAndHasNoValueForKeys(document)) {
            return;
        }
        for (KeyValue key : this.getKeyValues(document, false)) {
            KeyValue normalizedKey = key.normalized();
            if (!this.containsKey(normalizedKey)) continue;
            throw new DuplicateKeyError(this, collection, this.getKeys(), key);
        }
    }

    @Override
    public synchronized void add(Document document, P position, MongoCollection<P> collection) {
        this.checkAdd(document, collection);
        if (this.isSparseAndHasNoValueForKeys(document)) {
            return;
        }
        Set<KeyValue> keyValues = this.getKeyValues(document);
        for (KeyValue keyValue : keyValues) {
            boolean added = this.putKeyPosition(keyValue, position);
            Assert.isTrue(added, () -> "Key " + keyValue + " already exists. Concurrency issue?");
        }
    }

    @Override
    public synchronized void checkUpdate(Document oldDocument, Document newDocument, MongoCollection<P> collection) {
        if (this.nullAwareEqualsKeys(oldDocument, newDocument)) {
            return;
        }
        if (this.isSparseAndHasNoValueForKeys(newDocument)) {
            return;
        }
        P oldPosition = this.getDocumentPosition(oldDocument);
        for (KeyValue key : this.getKeyValues(newDocument, false)) {
            KeyValue normalizedKey = key.normalized();
            P position = this.getPosition(normalizedKey);
            if (position == null || position.equals(oldPosition)) continue;
            throw new DuplicateKeyError(this, collection, this.getKeys(), key);
        }
    }

    private P getDocumentPosition(Document oldDocument) {
        Set positions = this.getKeyValues(oldDocument).stream().map(this::getPosition).collect(StreamUtils.toLinkedHashSet());
        return (P)CollectionUtils.getSingleElement(positions);
    }

    @Override
    public void updateInPlace(Document oldDocument, Document newDocument, P position, MongoCollection<P> collection) throws KeyConstraintError {
        if (!this.nullAwareEqualsKeys(oldDocument, newDocument)) {
            P removedPosition = this.remove(oldDocument);
            if (removedPosition != null) {
                Assert.equals(removedPosition, position);
            }
            this.add(newDocument, position, collection);
        }
    }

    @Override
    public synchronized boolean canHandle(Document query) {
        if (!query.keySet().equals(this.keySet())) {
            return false;
        }
        if (this.isSparse() && query.values().stream().allMatch(Objects::isNull)) {
            return false;
        }
        for (String key : this.keys()) {
            Object queryValue = query.get(key);
            if (!(queryValue instanceof Document)) continue;
            if (this.isCompoundIndex()) {
                return false;
            }
            if (BsonRegularExpression.isRegularExpression(queryValue)) {
                return true;
            }
            for (String queriedKeys : ((Document)queryValue).keySet()) {
                if (AbstractUniqueIndex.isInQuery(queriedKeys) || !queriedKeys.startsWith("$")) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInQuery(String key) {
        return key.equals(QueryOperator.IN.getValue());
    }

    @Override
    public synchronized Iterable<P> getPositions(Document query) {
        KeyValue queriedKeyValues = this.getQueriedKeyValues(query);
        for (Object queriedValue : queriedKeyValues) {
            if (BsonRegularExpression.isRegularExpression(queriedValue)) {
                if (this.isCompoundIndex()) {
                    throw new UnsupportedOperationException("Not yet implemented");
                }
                ArrayList<P> positions = new ArrayList<P>();
                for (Map.Entry<KeyValue, P> entry : this.getIterable()) {
                    BsonRegularExpression regularExpression;
                    Matcher matcher;
                    Object o;
                    KeyValue obj = entry.getKey();
                    if (obj.size() != 1 || !((o = obj.get(0)) instanceof String) || !(matcher = (regularExpression = BsonRegularExpression.convertToRegularExpression(queriedValue)).matcher(o.toString())).find()) continue;
                    positions.add(entry.getValue());
                }
                return positions;
            }
            if (queriedValue instanceof Document) {
                String expression;
                if (this.isCompoundIndex()) {
                    throw new UnsupportedOperationException("Not yet implemented");
                }
                Document keyObj = (Document)queriedValue;
                if (!Utils.containsQueryExpression(keyObj) || !(expression = CollectionUtils.getSingleElement(keyObj.keySet(), () -> new UnsupportedOperationException("illegal query key: " + queriedKeyValues))).startsWith("$")) continue;
                return this.getPositionsForExpression(keyObj, expression);
            }
            if (!(queriedValue instanceof Collection)) continue;
            Collection values = (Collection)queriedValue;
            return values.stream().map(xva$0 -> new KeyValue(xva$0)).map(this::getPosition).filter(Objects::nonNull).collect(StreamUtils.toLinkedHashSet());
        }
        P position = this.getPosition(queriedKeyValues);
        if (position == null) {
            return List.of();
        }
        return List.of(position);
    }

    private KeyValue getQueriedKeyValues(Document query) {
        return new KeyValue(this.keys().stream().map(query::get).map(Utils::normalizeValue).collect(Collectors.toList()));
    }

    private Iterable<P> getPositionsForExpression(Document keyObj, String operator) {
        if (AbstractUniqueIndex.isInQuery(operator)) {
            Collection objects = (Collection)keyObj.get(operator);
            TreeSet<Object> queriedObjects = new TreeSet<Object>(ValueComparator.asc());
            queriedObjects.addAll(objects);
            ArrayList<P> allKeys = new ArrayList<P>();
            for (Object e : queriedObjects) {
                Object keyValue = Utils.normalizeValue(e);
                P key = this.getPosition(new KeyValue(keyValue));
                if (key == null) continue;
                allKeys.add(key);
            }
            return allKeys;
        }
        throw new UnsupportedOperationException("unsupported query expression: " + operator);
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public void drop() {
        log.debug("Dropping {}", (Object)this);
    }
}

