/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.util;

import ai.digital.integration.server.common.domain.AkkaSecured;
import ai.digital.integration.server.common.util.SslUtil;
import ai.digital.integration.server.deploy.domain.Satellite;
import ai.digital.integration.server.deploy.util.DeployServerUtil;
import ai.digital.integration.server.deploy.util.SatelliteUtil;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/util/SatelliteInitializeUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class SatelliteInitializeUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void prepare(@NotNull Project project, @NotNull Satellite satellite) {
        Companion.prepare(project, satellite);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lai/digital/integration/server/deploy/util/SatelliteInitializeUtil$Companion;", "", "()V", "prepare", "", "project", "Lorg/gradle/api/Project;", "satellite", "Lai/digital/integration/server/deploy/domain/Satellite;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public final void prepare(@NotNull Project project, @NotNull Satellite satellite) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)satellite, (String)"satellite");
            File satelliteConf = SatelliteUtil.Companion.getSatelliteConf(project, satellite);
            ConfigRenderOptions options = ConfigRenderOptions.concise().setFormatted(true).setJson(false);
            Config newConfiguration = ConfigFactory.parseString((String)FilesKt.readText((File)satelliteConf, (Charset)Charsets.UTF_8)).withValue("deploy.server.bind-hostname", ConfigValueFactory.fromAnyRef((Object)satellite.getServerAkkaBindHostName())).withValue("deploy.server.hostname", ConfigValueFactory.fromAnyRef((Object)satellite.getServerAkkaHostname())).withValue("deploy.server.port", ConfigValueFactory.fromAnyRef((Object)satellite.getServerAkkaPort())).withValue("deploy.satellite.metrics.port", ConfigValueFactory.fromAnyRef((Object)satellite.getMetricsPort())).withValue("deploy.satellite.streaming.port", ConfigValueFactory.fromAnyRef((Object)satellite.getAkkaStreamingPort()));
            if (DeployServerUtil.Companion.isAkkaSecured(project)) {
                AkkaSecured secured;
                AkkaSecured akkaSecured = secured = SslUtil.Companion.getAkkaSecured(project, DeployServerUtil.Companion.getServerWorkingDir(project));
                if (akkaSecured != null) {
                    Object object;
                    AkkaSecured akkaSecured2 = akkaSecured;
                    boolean bl = false;
                    boolean bl2 = false;
                    AkkaSecured it = akkaSecured2;
                    boolean bl3 = false;
                    AkkaSecured.KeyMeta key = secured.getKeys().get("akka_ssl_satellite_" + satellite.getName());
                    AkkaSecured.KeyMeta keyMeta = key;
                    newConfiguration = newConfiguration.withValue("deploy.server.ssl.enabled", ConfigValueFactory.fromAnyRef((Object)"yes")).withValue("deploy.server.ssl.key-store", ConfigValueFactory.fromAnyRef((object = key) != null && (object = ((AkkaSecured.KeyMeta)object).keyStoreFile()) != null ? ((File)object).getAbsolutePath() : null)).withValue("deploy.server.ssl.key-store-password", ConfigValueFactory.fromAnyRef((Object)(keyMeta != null ? keyMeta.getKeyStorePassword() : null))).withValue("deploy.server.ssl.trust-store", ConfigValueFactory.fromAnyRef((Object)secured.trustStoreFile().getAbsolutePath())).withValue("deploy.server.ssl.trust-store-password", ConfigValueFactory.fromAnyRef((Object)secured.getTruststorePassword()));
                    if (Intrinsics.areEqual((Object)"jks", (Object)"pkcs12") ^ true) {
                        AkkaSecured.KeyMeta keyMeta2 = key;
                        newConfiguration = newConfiguration.withValue("deploy.server.ssl.key-password", ConfigValueFactory.fromAnyRef((Object)(keyMeta2 != null ? keyMeta2.getKeyPassword() : null)));
                    }
                }
            }
            String string = newConfiguration.root().render(options);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newConfiguration\n       \u2026         .render(options)");
            FilesKt.writeText$default((File)satelliteConf, (String)string, null, (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

