/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.vagrant;

import com.xebialabs.overcast.command.Command;
import com.xebialabs.overcast.command.CommandProcessor;
import com.xebialabs.overcast.command.CommandResponse;
import com.xebialabs.overcast.support.vagrant.VagrantState;

public class VagrantDriver {
    private String hostLabel;
    private CommandProcessor commandProcessor;

    public VagrantDriver(String hostLabel, CommandProcessor commandProcessor) {
        this.hostLabel = hostLabel;
        this.commandProcessor = commandProcessor;
    }

    public CommandResponse doVagrant(String vagrantVm, String ... vagrantCommand) {
        CommandResponse response = this.commandProcessor.run(Command.aCommand("vagrant").withArguments(vagrantCommand).withOptions(vagrantVm));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Errors during vagrant execution: \n" + response.getErrors());
        }
        for (String line : response.getOutput().split("\n\u001b")) {
            if (!line.startsWith("[1;35merr:")) continue;
            throw new RuntimeException("Error in puppet output: " + line);
        }
        return response;
    }

    public CommandResponse status(String vm) {
        return this.doVagrant(vm, "status");
    }

    public VagrantState state(String vm) {
        return VagrantState.fromStatusString(this.status(vm).getOutput());
    }

    public String toString() {
        return this.hostLabel;
    }
}

