/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.host;

import com.xebialabs.overcast.OvercastProperties;
import com.xebialabs.overcast.host.CloudHost;
import com.xebialabs.overcast.support.libvirt.DomainWrapper;
import com.xebialabs.overcast.support.libvirt.Filesystem;
import com.xebialabs.overcast.support.libvirt.IpLookupStrategy;
import com.xebialabs.overcast.support.libvirt.SshIpLookupStrategy;
import com.xebialabs.overcast.support.libvirt.StaticIpLookupStrategy;
import java.util.List;
import java.util.UUID;
import org.libvirt.Connect;
import org.libvirt.DomainInfo;
import org.libvirt.LibvirtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LibvirtHost
implements CloudHost {
    private static final Logger logger = LoggerFactory.getLogger(LibvirtHost.class);
    public static final String LIBVIRT_URL_PROPERTY_SUFFIX = ".libvirtURL";
    public static final String LIBVIRT_START_TIMEOUT_PROPERTY_SUFFIX = ".libvirtStartTimeout";
    public static final String LIBVIRT_START_TIMEOUT_DEFAULT = "30";
    public static final String LIBVIRT_BOOT_DELAY_PROPERTY_SUFFIX = ".bootDelay";
    public static final String LIBVIRT_BOOT_DELAY_DEFAULT = "0";
    public static final String LIBVIRT_BASE_DOMAIN_PROPERTY_SUFFIX = ".baseDomain";
    public static final String LIBVIRT_NETWORK_DEVICE_ID_PROPERTY_SUFFIX = ".network";
    public static final String LIBVIRT_IP_LOOKUP_STRATEGY_PROPERTY_SUFFIX = ".ipLookupStrategy";
    public static final String LIBVIRT_FS_MAPPING_SUFFIX = ".fsMapping";
    public static final String LIBVIRT_URL_DEFAULT = "qemu:///system";
    public static final String LIBVIRT_BOOT_SECONDS_DEFAULT = "60";
    private int startTimeout;
    private int bootDelay;
    private final String networkName;
    protected Connect libvirt;
    private final DomainWrapper baseDomain;
    private final String baseDomainName;
    private DomainWrapper clone;
    private String hostIp;
    private IpLookupStrategy ipLookupStrategy;
    private List<Filesystem> filesystemMappings;

    public LibvirtHost(Connect libvirt, String baseDomainName, IpLookupStrategy ipLookupStrategy, String networkName, int startTimeout, int bootDelay, List<Filesystem> filesystemMappings) {
        this.libvirt = libvirt;
        this.baseDomainName = baseDomainName;
        this.startTimeout = startTimeout;
        this.bootDelay = bootDelay;
        this.networkName = networkName;
        this.ipLookupStrategy = ipLookupStrategy;
        this.filesystemMappings = filesystemMappings;
        try {
            this.baseDomain = DomainWrapper.newWrapper(libvirt.domainLookupByName(baseDomainName));
        }
        catch (LibvirtException e) {
            throw new RuntimeException(e);
        }
    }

    public static IpLookupStrategy determineIpLookupStrategy(String hostLabel) {
        String strategy = OvercastProperties.getRequiredOvercastProperty(hostLabel + LIBVIRT_IP_LOOKUP_STRATEGY_PROPERTY_SUFFIX);
        if ("SSH".equals(strategy)) {
            return SshIpLookupStrategy.create(hostLabel);
        }
        if ("static".equals(strategy)) {
            return StaticIpLookupStrategy.create(hostLabel);
        }
        throw new RuntimeException(String.format("Unsupported IP lookup strategy: '%s'", strategy));
    }

    public Connect getLibvirt() {
        return this.libvirt;
    }

    @Override
    public void setup() {
        if (this.baseDomain.getState() != DomainInfo.DomainState.VIR_DOMAIN_SHUTOFF) {
            throw new IllegalStateException(String.format("baseDomain '%s' must be shut off before it can be cloned.", this.baseDomainName));
        }
        this.clone = this.createClone();
        this.hostIp = this.waitUntilRunningAndGetIP(this.clone);
        this.bootDelay(this.bootDelay);
    }

    @Override
    public void teardown() {
        if (this.clone != null) {
            this.clone.destroyWithDisks();
            this.clone = null;
        }
    }

    @Override
    public String getHostName() {
        return this.hostIp;
    }

    @Override
    public int getPort(int port) {
        return port;
    }

    public DomainWrapper getClone() {
        return this.clone;
    }

    public String getBaseDomainName() {
        return this.baseDomainName;
    }

    protected DomainWrapper createClone() {
        String baseName = this.baseDomain.getName();
        String cloneName = baseName + "-" + UUID.randomUUID().toString();
        logger.info("Creating clone '{}' from base domain '{}'", (Object)cloneName, (Object)baseName);
        return this.baseDomain.cloneWithBackingStore(cloneName, this.filesystemMappings);
    }

    protected String waitUntilRunningAndGetIP(DomainWrapper clone) {
        String name = clone.getName();
        try {
            DomainInfo.DomainState state = DomainInfo.DomainState.VIR_DOMAIN_NOSTATE;
            for (int seconds = this.startTimeout; state != DomainInfo.DomainState.VIR_DOMAIN_RUNNING && seconds >= 0; --seconds) {
                state = clone.getState();
                logger.debug("Waiting {}s for clone '{}' to become running ({})", new Object[]{seconds, name, state});
                LibvirtHost.sleep(1);
            }
            if (state != DomainInfo.DomainState.VIR_DOMAIN_RUNNING) {
                String msg = String.format("Clone '%s' not running after %d seconds (state=%s)", name, this.startTimeout, state);
                throw new RuntimeException(msg);
            }
            logger.info("Clone '{}' running determining IP", new Object[]{name, this.startTimeout, state});
            String mac = clone.getMac(this.networkName);
            return this.ipLookupStrategy.lookup(mac);
        }
        catch (RuntimeException bootupFailure) {
            logger.error("Clone '{}' did not reach a usable state destroying. ({})", (Object)name, (Object)bootupFailure.getMessage());
            clone.destroyWithDisks();
            throw bootupFailure;
        }
    }

    protected void bootDelay(int delaySeconds) {
        logger.info("Waiting {} seconds for VM to boot up", (Object)delaySeconds);
        LibvirtHost.sleep(delaySeconds);
    }

    protected static void sleep(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

