/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.host;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.xebialabs.overcast.OvercastProperties;
import com.xebialabs.overcast.host.CloudHost;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Ec2CloudHost
implements CloudHost {
    public static final String AMI_AVAILABILITY_ZONE_PROPERTY_SUFFIX = ".amiAvailabilityZone";
    public static final String AMI_BOOT_SECONDS_PROPERTY_SUFFIX = ".amiBootSeconds";
    public static final String AMI_ID_PROPERTY_SUFFIX = ".amiId";
    public static final String AMI_INSTANCE_TYPE_PROPERTY_SUFFIX = ".amiInstanceType";
    public static final String AMI_KEY_NAME_PROPERTY_SUFFIX = ".amiKeyName";
    public static final String AMI_SECURITY_GROUP_PROPERTY_SUFFIX = ".amiSecurityGroup";
    public static final String AWS_ACCESS_KEY_PROPERTY = "aws.accessKey";
    public static final String AWS_ENDPOINT_DEFAULT = "https://ec2.amazonaws.com";
    public static final String AWS_ENDPOINT_PROPERTY = "aws.endpoint";
    public static final String AWS_SECRET_KEY_PROPERTY = "aws.secretKey";
    private final String hostLabel;
    private final String amiId;
    private final String awsEndpointURL;
    private final String awsAccessKey;
    private final String awsSecretKey;
    private final String amiAvailabilityZone;
    private final String amiInstanceType;
    private final String amiSecurityGroup;
    private final String amiKeyName;
    private final int amiBootSeconds;
    private AmazonEC2Client ec2;
    private String instanceId;
    private String publicDnsAddress;
    private static final Logger logger = LoggerFactory.getLogger(Ec2CloudHost.class);

    public Ec2CloudHost(String hostLabel, String amiId) {
        this.hostLabel = hostLabel;
        this.amiId = amiId;
        this.awsEndpointURL = OvercastProperties.getOvercastProperty(AWS_ENDPOINT_PROPERTY, AWS_ENDPOINT_DEFAULT);
        this.awsAccessKey = OvercastProperties.getRequiredOvercastProperty(AWS_ACCESS_KEY_PROPERTY);
        this.awsSecretKey = OvercastProperties.getRequiredOvercastProperty(AWS_SECRET_KEY_PROPERTY);
        this.amiAvailabilityZone = OvercastProperties.getOvercastProperty(hostLabel + AMI_AVAILABILITY_ZONE_PROPERTY_SUFFIX, null);
        this.amiInstanceType = OvercastProperties.getRequiredOvercastProperty(hostLabel + AMI_INSTANCE_TYPE_PROPERTY_SUFFIX);
        this.amiSecurityGroup = OvercastProperties.getRequiredOvercastProperty(hostLabel + AMI_SECURITY_GROUP_PROPERTY_SUFFIX);
        this.amiKeyName = OvercastProperties.getRequiredOvercastProperty(hostLabel + AMI_KEY_NAME_PROPERTY_SUFFIX);
        this.amiBootSeconds = Integer.valueOf(OvercastProperties.getRequiredOvercastProperty(hostLabel + AMI_BOOT_SECONDS_PROPERTY_SUFFIX));
        this.ec2 = new AmazonEC2Client((AWSCredentials)new BasicAWSCredentials(this.awsAccessKey, this.awsSecretKey));
        this.ec2.setEndpoint(this.awsEndpointURL);
    }

    @Override
    public void setup() {
        this.instanceId = this.runInstance();
        this.publicDnsAddress = this.waitUntilRunningAndGetPublicDnsName();
        this.setInstanceName();
        this.waitForAmiBoot();
    }

    @Override
    public void teardown() {
        this.ec2.terminateInstances(new TerminateInstancesRequest(Arrays.asList(this.instanceId)));
    }

    @Override
    public String getHostName() {
        return this.publicDnsAddress;
    }

    @Override
    public int getPort(int port) {
        return port;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getPublicDnsAddress() {
        return this.publicDnsAddress;
    }

    public String getAmiId() {
        return this.amiId;
    }

    public String getHostLabel() {
        return this.hostLabel;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public String getAmiAvailabilityZone() {
        return this.amiAvailabilityZone;
    }

    public String getAmiInstanceType() {
        return this.amiInstanceType;
    }

    public String getAmiSecurityGroup() {
        return this.amiSecurityGroup;
    }

    public String getAmiKeyName() {
        return this.amiKeyName;
    }

    public int getAmiBootSeconds() {
        return this.amiBootSeconds;
    }

    protected String runInstance() {
        RunInstancesRequest run = new RunInstancesRequest(this.amiId, Integer.valueOf(1), Integer.valueOf(1));
        run.withInstanceInitiatedShutdownBehavior("terminate");
        if (this.amiInstanceType != null) {
            run.withInstanceType(this.amiInstanceType);
        }
        if (this.amiSecurityGroup != null) {
            run.withSecurityGroups(new String[]{this.amiSecurityGroup});
        }
        if (this.amiKeyName != null) {
            run.withKeyName(this.amiKeyName);
        }
        if (this.amiAvailabilityZone != null) {
            run.withPlacement(new Placement(this.amiAvailabilityZone));
        }
        RunInstancesResult result = this.ec2.runInstances(run);
        return ((Instance)result.getReservation().getInstances().get(0)).getInstanceId();
    }

    protected void setInstanceName() {
        this.ec2.createTags(new CreateTagsRequest(Arrays.asList(this.instanceId), Arrays.asList(new Tag("Name", this.hostLabel + " started at " + new Date()))));
    }

    public String waitUntilRunningAndGetPublicDnsName() {
        Ec2CloudHost.sleep(5);
        DescribeInstancesRequest describe;
        Instance instance;
        while (!(instance = (Instance)((Reservation)this.ec2.describeInstances(describe = new DescribeInstancesRequest().withInstanceIds(Arrays.asList(this.instanceId))).getReservations().get(0)).getInstances().get(0)).getState().getName().equals("running")) {
            logger.info("Instance {} is still {}. Waiting...", (Object)this.instanceId, (Object)instance.getState().getName());
            Ec2CloudHost.sleep(1);
        }
        return instance.getPublicDnsName();
    }

    protected void waitForAmiBoot() {
        logger.info("Waiting {} seconds for the image to finish booting", (Object)this.amiBootSeconds);
        Ec2CloudHost.sleep(this.amiBootSeconds);
    }

    private static void sleep(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

