/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.host;

import com.xebialabs.overcast.host.CloudHost;
import com.xebialabs.overcast.support.docker.DockerDriver;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHost
implements CloudHost {
    private final DockerDriver dockerDriver;
    private final String image;
    private final URI uri;
    private String name;
    private List<String> env;
    private List<String> command;
    private boolean tty;
    private boolean remove;
    private boolean removeVolume;
    private boolean exposeAllPorts = false;
    private Set<String> exposedPorts;
    private Set<String> portBindings;
    private List<String> links;
    private static final Logger logger = LoggerFactory.getLogger(DockerHost.class);

    public DockerHost(String image, String dockerHostName, Path certificatesPath) {
        try {
            this.image = image;
            if (dockerHostName != null) {
                this.uri = new URI(dockerHostName);
                if ("https".equals(this.uri.getScheme()) && certificatesPath == null) {
                    throw new IllegalArgumentException("<host>.certificates must be configured for https connection");
                }
            } else {
                this.uri = null;
            }
            this.dockerDriver = new DockerDriver(this, certificatesPath);
        }
        catch (URISyntaxException e) {
            logger.error("Invalid dockerHost " + dockerHostName, (Throwable)e);
            throw new IllegalArgumentException("Invalid dockerHost " + e.getMessage());
        }
    }

    @Override
    public void setup() {
        this.dockerDriver.runContainer();
    }

    @Override
    public void teardown() {
        this.dockerDriver.killAndRemoveContainer();
    }

    @Override
    public int getPort(int port) {
        return this.dockerDriver.getPort(port);
    }

    @Override
    public String getHostName() {
        return this.dockerDriver.getHost();
    }

    public String getImage() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public boolean isExposeAllPorts() {
        return this.exposeAllPorts;
    }

    public URI getUri() {
        return this.uri;
    }

    public DockerDriver getDockerDriver() {
        return this.dockerDriver;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public void setExposeAllPorts(boolean exposeAllPorts) {
        this.exposeAllPorts = exposeAllPorts;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean isRemoveVolume() {
        return this.removeVolume;
    }

    public void setRemoveVolume(boolean removeVolume) {
        this.removeVolume = removeVolume;
    }

    public List<String> getEnv() {
        return this.env;
    }

    public void setEnv(List<String> env) {
        this.env = env;
    }

    public Set<String> getExposedPorts() {
        return this.exposedPorts;
    }

    public void setExposedPorts(Set<String> exposedPorts) {
        this.exposedPorts = exposedPorts;
    }

    public boolean isTty() {
        return this.tty;
    }

    public void setTty(boolean tty) {
        this.tty = tty;
    }

    public List<String> getLinks() {
        return this.links;
    }

    public void setLinks(List<String> links) {
        this.links = links;
    }

    public Set<String> getPortBindings() {
        return this.portBindings;
    }

    public void setPortBindings(Set<String> portBindings) {
        this.portBindings = portBindings;
    }

    public boolean hasNoPortBindings() {
        return this.portBindings == null || this.portBindings.isEmpty();
    }

    public boolean hasPortBindings() {
        return !this.hasNoPortBindings();
    }
}

