/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.host;

import com.xebialabs.overcast.OverthereUtil;
import com.xebialabs.overcast.Preconditions;
import com.xebialabs.overcast.command.Command;
import com.xebialabs.overcast.command.CommandProcessor;
import com.xebialabs.overcast.command.NonZeroCodeException;
import com.xebialabs.overcast.host.LibvirtHost;
import com.xebialabs.overcast.support.libvirt.DomainWrapper;
import com.xebialabs.overcast.support.libvirt.Filesystem;
import com.xebialabs.overcast.support.libvirt.IpLookupStrategy;
import com.xebialabs.overcast.support.libvirt.LibvirtRuntimeException;
import com.xebialabs.overcast.support.libvirt.LibvirtUtil;
import com.xebialabs.overcast.support.libvirt.LoggingOutputHandler;
import com.xebialabs.overcast.support.libvirt.Metadata;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.util.CapturingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.MultipleOverthereExecutionOutputHandler;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jdom2.Document;
import org.libvirt.Connect;
import org.libvirt.Domain;
import org.libvirt.LibvirtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedLibvirtHost
extends LibvirtHost {
    private static final Logger logger = LoggerFactory.getLogger(CachedLibvirtHost.class);
    public static final String DEFAULT_STALE_HOST_GRACE_TIME = "3600000";
    public static final String PROVISION_CMD = ".provision.cmd";
    public static final String PROVISION_URL = ".provision.url";
    public static final String PROVISION_START_TIMEOUT = ".provision.startTimeout";
    public static final String PROVISION_START_TIMEOUT_DEFAULT = "60";
    public static final String COPY_SPEC = ".provision.copy";
    public static final String CACHE_EXPIRATION_CMD = ".provision.expirationTag.cmd";
    public static final String CACHE_EXPIRATION_URL = ".provision.expirationTag.url";
    public static final String PROVISIONED_BOOT_DELAY = ".provision.bootDelay";
    private final String provisionCmd;
    private final String provisionUrl;
    private final String cacheExpirationUrl;
    private final String cacheExpirationCmd;
    private CommandProcessor cmdProcessor;
    private final List<String> copySpec;
    private DomainWrapper provisionedClone;
    private String provisionedCloneIp;
    private int provisionedbootDelay;
    private int provisionStartTimeout;

    CachedLibvirtHost(String hostLabel, Connect libvirt, String baseDomainName, IpLookupStrategy ipLookupStrategy, String networkName, String provisionUrl, String provisionCmd, String cacheExpirationUrl, String cacheExpirationCmd, CommandProcessor cmdProcessor, int startTimeout, int bootDelay, int provisionStartTimeout, int provisionedbootDelay, List<Filesystem> filesystemMappings, List<String> copySpec) {
        super(libvirt, baseDomainName, ipLookupStrategy, networkName, startTimeout, bootDelay, filesystemMappings);
        this.provisionUrl = this.checkNotNullTrimAndNotEmpty(provisionUrl, "provisionUrl");
        this.provisionCmd = this.checkNotNullTrimAndNotEmpty(provisionCmd, "provisionCmd");
        this.cacheExpirationUrl = cacheExpirationUrl;
        this.cacheExpirationCmd = this.checkNotNullTrimAndNotEmpty(cacheExpirationCmd, "cacheExpirationCmd");
        this.provisionedbootDelay = provisionedbootDelay;
        this.provisionStartTimeout = provisionStartTimeout;
        this.cmdProcessor = cmdProcessor;
        this.copySpec = copySpec;
    }

    private String checkNotNullTrimAndNotEmpty(String arg, String argName) {
        Preconditions.checkArgument(arg != null, "%s cannot be null", argName);
        arg = arg.trim();
        Preconditions.checkArgument(!arg.isEmpty(), "%s cannot be empty", argName);
        return arg;
    }

    @Override
    public void setup() {
        DomainWrapper cachedDomain = this.findFirstCachedDomain();
        if (cachedDomain == null) {
            logger.info("No cached domain, creating a new cached domain");
            super.setup();
            String ip = super.getHostName();
            this.provisionDomain(ip, this.copySpec, this.provisionStartTimeout);
            DomainWrapper clone = super.getClone();
            clone.acpiShutdown();
            clone.updateMetadata(this.getBaseDomainName(), this.provisionCmd, this.getExpirationTag(), new Date());
            this.provisionedClone = this.createProvisionedClone();
        } else {
            String baseName = super.getBaseDomainName();
            String cloneName = baseName + "-" + UUID.randomUUID().toString();
            logger.info("Creating clone '{}' from cached domain '{}'", (Object)cloneName, (Object)cachedDomain.getName());
            this.provisionedClone = cachedDomain.cloneWithBackingStore(cloneName);
        }
        this.provisionedCloneIp = this.waitUntilRunningAndGetIP(this.provisionedClone);
        this.bootDelay(this.provisionedbootDelay);
    }

    protected void provisionDomain(String ip, List<String> copySpec, int startTimeout) {
        String baseDomainName;
        block12: {
            OverthereConnection remote = null;
            int seconds = startTimeout;
            baseDomainName = this.getBaseDomainName();
            while (true) {
                if (seconds < 0) break block12;
                try {
                    remote = this.getRemoteConnection(ip);
                    this.copyFiles(remote, copySpec);
                    this.provisionHost(remote, ip);
                    return;
                }
                catch (RuntimeIOException e) {
                    try {
                        Throwable cause;
                        for (cause = e.getCause(); cause != null && !(cause instanceof ConnectException) && !(cause instanceof NoRouteToHostException); cause = cause.getCause()) {
                        }
                        if (!(cause instanceof ConnectException) && !(cause instanceof NoRouteToHostException)) {
                            throw e;
                        }
                        logger.debug("Could not connect to '{}' at '{}' for provisioning, retrying", (Object)baseDomainName, (Object)ip);
                        CachedLibvirtHost.sleep(1);
                        --seconds;
                    }
                    catch (RuntimeException e2) {
                        logger.error("Failed to provision '{}' cleaning up", (Object)baseDomainName);
                        super.getClone().destroyWithDisks();
                        throw e2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (remote != null) {
                    remote.close();
                }
            }
        }
        super.getClone().destroyWithDisks();
        throw new RuntimeException(String.format("Could not start provisioning clone from '%s' within %d seconds", baseDomainName, startTimeout));
    }

    protected DomainWrapper findFirstCachedDomain() {
        String baseDomainName = super.getBaseDomainName();
        String checkSum = this.getExpirationTag();
        logger.debug("Looking for a cached domain '{}' with checksum '{}'", (Object)baseDomainName, (Object)checkSum);
        try {
            List<Domain> domains = LibvirtUtil.getDefinedDomains(this.libvirt);
            for (Domain domain : domains) {
                String domainName = domain.getName();
                Document doc = LibvirtUtil.loadDomainXml(domain);
                Metadata md = Metadata.fromXml(doc);
                if (md == null || !md.isProvisioned()) continue;
                logger.debug("Found domain '{}' with metadata {}", (Object)domainName, (Object)md);
                if (!md.getParentDomain().equals(baseDomainName) || !md.getProvisionedWith().equals(this.provisionCmd)) continue;
                if (!md.getProvisionedChecksum().equals(checkSum)) {
                    logger.debug("Domain '{}' is stale (checksum={})", (Object)domainName, (Object)md.getProvisionedChecksum());
                    this.deleteStaleDomain(new DomainWrapper(domain, doc));
                    continue;
                }
                logger.debug("Found domain '{}' found for '{}'", (Object)domainName, (Object)baseDomainName);
                return new DomainWrapper(domain, doc);
            }
            logger.debug("No cached domain found for '{}' with checksum '{}'", (Object)baseDomainName, (Object)checkSum);
            return null;
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException(e);
        }
    }

    protected void deleteStaleDomain(DomainWrapper staleDomain) throws LibvirtException {
        String staleDomainName = staleDomain.getName();
        if (CachedLibvirtHost.isDomainSafeToDelete(this.libvirt, staleDomainName)) {
            try {
                logger.info("Destroying stale domain '{}'", (Object)staleDomainName);
                staleDomain.destroyWithDisks();
            }
            catch (LibvirtRuntimeException e) {
                logger.debug("Ignoring exception while cleaning stale domain", (Throwable)e);
            }
        }
    }

    protected static boolean isDomainSafeToDelete(Connect libvirt, String staleDomainName) throws LibvirtException {
        List<Domain> domains = LibvirtUtil.getRunningDomains(libvirt);
        for (Domain domain : domains) {
            Document doc = LibvirtUtil.loadDomainXml(domain);
            Metadata md = Metadata.fromXml(doc);
            if (md == null || md.isProvisioned() || !md.getParentDomain().equals(staleDomainName)) continue;
            logger.info("Not deleting stale domain '{}' still used by '{}'", (Object)staleDomainName, (Object)domain.getName());
            return false;
        }
        return true;
    }

    @Override
    public DomainWrapper getClone() {
        return this.provisionedClone;
    }

    @Override
    public String getHostName() {
        return this.provisionedCloneIp;
    }

    @Override
    public void teardown() {
        if (this.provisionedClone != null) {
            this.provisionedClone.destroyWithDisks();
            this.provisionedClone = null;
        }
    }

    protected String getExpirationTag() {
        logger.info("Executing expiration tag command: {}", (Object)this.cacheExpirationCmd);
        if (this.cacheExpirationUrl == null) {
            return this.getLocalExpirationTag();
        }
        return this.getRemoteExpirationTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoteExpirationTag() {
        try (OverthereConnection connection = null;){
            connection = OverthereUtil.overthereConnectionFromURI(this.cacheExpirationUrl);
            CapturingOverthereExecutionOutputHandler stdOutCapture = CapturingOverthereExecutionOutputHandler.capturingHandler();
            CapturingOverthereExecutionOutputHandler stdErrCapture = CapturingOverthereExecutionOutputHandler.capturingHandler();
            CmdLine cmd = new CmdLine();
            cmd.addRaw(this.cacheExpirationCmd);
            int exitCode = connection.execute((OverthereExecutionOutputHandler)stdOutCapture, (OverthereExecutionOutputHandler)stdErrCapture, cmd);
            if (exitCode != 0) {
                throw new RuntimeException(String.format("Error getting expiration tag exit code %d, stdout=%s, stderr=%s", exitCode, stdOutCapture.getOutput(), stdErrCapture.getOutput()));
            }
            String string = stdOutCapture.getOutput();
            return string;
        }
    }

    private String getLocalExpirationTag() {
        try {
            String expirationTag = this.cmdProcessor.run(Command.fromString(this.cacheExpirationCmd)).getOutput().trim();
            return expirationTag;
        }
        catch (NonZeroCodeException e) {
            throw new IllegalArgumentException(String.format("Command %s returned code %s with the following errors: \n\n%s\n", e.getCommand().toString(), e.getResponse().getReturnCode(), e.getResponse().getErrors() + "\n\n" + e.getResponse().getOutput()));
        }
    }

    protected DomainWrapper createProvisionedClone() {
        DomainWrapper base = super.getClone();
        String baseName = super.getBaseDomainName();
        String cloneName = baseName + "-" + UUID.randomUUID().toString();
        logger.info("Creating clone '{}' from provisioned domain '{}'", (Object)cloneName, (Object)base.getName());
        return base.cloneWithBackingStore(cloneName);
    }

    protected OverthereConnection getRemoteConnection(String ip) {
        String finalUrl = MessageFormat.format(this.provisionUrl, ip);
        return OverthereUtil.overthereConnectionFromURI(finalUrl);
    }

    protected void copyFiles(OverthereConnection remote, List<String> copySpec) {
        if (copySpec.isEmpty()) {
            return;
        }
        logger.info("Copying files into host: {}", copySpec);
        OverthereConnection local = LocalConnection.getLocalConnection();
        OverthereUtil.copyFiles(local, remote, copySpec);
    }

    protected void provisionHost(OverthereConnection remote, String ip) {
        int exitCode;
        CmdLine cmdLine = new CmdLine();
        String fragment = MessageFormat.format(this.provisionCmd, ip);
        cmdLine.addRaw(fragment);
        logger.info("Provisioning host with '{}'", (Object)cmdLine);
        CapturingOverthereExecutionOutputHandler stdOutCapture = CapturingOverthereExecutionOutputHandler.capturingHandler();
        CapturingOverthereExecutionOutputHandler stdErrCapture = CapturingOverthereExecutionOutputHandler.capturingHandler();
        CapturingOverthereExecutionOutputHandler stdOutHandler = stdOutCapture;
        CapturingOverthereExecutionOutputHandler stdErrHandler = stdErrCapture;
        if (logger.isInfoEnabled()) {
            LoggingOutputHandler stdout = new LoggingOutputHandler(logger, "out");
            stdOutHandler = MultipleOverthereExecutionOutputHandler.multiHandler((OverthereExecutionOutputHandler[])new OverthereExecutionOutputHandler[]{stdOutCapture, stdout});
            LoggingOutputHandler stderr = new LoggingOutputHandler(logger, "err");
            stdErrHandler = MultipleOverthereExecutionOutputHandler.multiHandler((OverthereExecutionOutputHandler[])new OverthereExecutionOutputHandler[]{stdErrCapture, stderr});
        }
        if ((exitCode = remote.execute((OverthereExecutionOutputHandler)stdOutHandler, (OverthereExecutionOutputHandler)stdErrHandler, cmdLine)) != 0) {
            throw new RuntimeException(String.format("Provisioning of clone from '%s' failed with exit code %d", this.getBaseDomainName(), exitCode));
        }
        if (!stdErrCapture.getOutputLines().isEmpty()) {
            throw new RuntimeException(String.format("Provisioning of clone from '%s' failed with output to stderr: '%s'", this.getBaseDomainName(), stdErrCapture.getOutput()));
        }
    }
}

