/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.SystemClock;
import android.os.Vibrator;
import android.provider.Settings;

public class HapticFeedbackController {
    private static final int VIBRATE_DELAY_MS = 125;
    private static final int VIBRATE_LENGTH_MS = 50;
    private final Context mContext;
    private final ContentObserver mContentObserver;
    private Vibrator mVibrator;
    private boolean mIsGloballyEnabled;
    private long mLastVibrate;

    private static boolean checkGlobalSetting(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"haptic_feedback_enabled", (int)0) == 1;
    }

    public HapticFeedbackController(Context context) {
        this.mContext = context;
        this.mContentObserver = new ContentObserver(null){

            public void onChange(boolean selfChange) {
                HapticFeedbackController.this.mIsGloballyEnabled = HapticFeedbackController.checkGlobalSetting(HapticFeedbackController.this.mContext);
            }
        };
    }

    public void start() {
        if (this.hasVibratePermission(this.mContext)) {
            this.mVibrator = (Vibrator)this.mContext.getSystemService("vibrator");
        }
        this.mIsGloballyEnabled = HapticFeedbackController.checkGlobalSetting(this.mContext);
        Uri uri = Settings.System.getUriFor((String)"haptic_feedback_enabled");
        this.mContext.getContentResolver().registerContentObserver(uri, false, this.mContentObserver);
    }

    private boolean hasVibratePermission(Context context) {
        PackageManager pm = context.getPackageManager();
        int hasPerm = pm.checkPermission("android.permission.VIBRATE", context.getPackageName());
        return hasPerm == 0;
    }

    public void stop() {
        this.mVibrator = null;
        this.mContext.getContentResolver().unregisterContentObserver(this.mContentObserver);
    }

    public void tryVibrate() {
        long now;
        if (this.mVibrator != null && this.mIsGloballyEnabled && (now = SystemClock.uptimeMillis()) - this.mLastVibrate >= 125L) {
            this.mVibrator.vibrate(50L);
            this.mLastVibrate = now;
        }
    }
}

