/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.interceptor;

import com.volcengine.ApiException;
import com.volcengine.interceptor.InterceptorContext;
import com.volcengine.interceptor.RequestInterceptor;
import com.volcengine.interceptor.ResponseInterceptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class InterceptorChain {
    private List<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>();
    private List<ResponseInterceptor> responseInterceptors = new ArrayList<ResponseInterceptor>();

    private static void checkRequestInterceptor(RequestInterceptor interceptor) {
        if (interceptor == null) {
            throw new IllegalArgumentException("interceptor is null");
        }
    }

    private static void checkResponseInterceptor(ResponseInterceptor interceptor) {
        if (interceptor == null) {
            throw new IllegalArgumentException("interceptor is null");
        }
    }

    private static <T> List<T> insertInterceptor(List<T> chain, T interceptor, String afterName) {
        if (StringUtils.isEmpty((String)afterName)) {
            chain.add(0, interceptor);
            return chain;
        }
        for (int i = 0; i < chain.size(); ++i) {
            ResponseInterceptor respInterceptor;
            T current = chain.get(i);
            if (current instanceof RequestInterceptor) {
                RequestInterceptor reqInterceptor = (RequestInterceptor)current;
                if (!reqInterceptor.name().equals(afterName)) continue;
                chain.add(i + 1, interceptor);
                return chain;
            }
            if (!(current instanceof ResponseInterceptor) || !(respInterceptor = (ResponseInterceptor)current).name().equals(afterName)) continue;
            chain.add(i + 1, interceptor);
            return chain;
        }
        throw new IllegalArgumentException("interceptor insert after name not found");
    }

    public InterceptorChain appendRequestInterceptor(RequestInterceptor interceptor) {
        InterceptorChain.checkRequestInterceptor(interceptor);
        this.requestInterceptors.add(interceptor);
        return this;
    }

    public InterceptorChain insertRequestInterceptor(RequestInterceptor interceptor, String afterName) {
        InterceptorChain.checkRequestInterceptor(interceptor);
        InterceptorChain.insertInterceptor(this.requestInterceptors, interceptor, afterName);
        return this;
    }

    public InterceptorChain appendResponseInterceptor(ResponseInterceptor interceptor) {
        InterceptorChain.checkResponseInterceptor(interceptor);
        this.responseInterceptors.add(interceptor);
        return this;
    }

    public InterceptorChain insertResponseInterceptor(ResponseInterceptor interceptor, String afterName) {
        InterceptorChain.checkResponseInterceptor(interceptor);
        InterceptorChain.insertInterceptor(this.responseInterceptors, interceptor, afterName);
        return this;
    }

    public InterceptorContext executeRequest(InterceptorContext context) throws ApiException {
        for (RequestInterceptor interceptor : this.requestInterceptors) {
            context = interceptor.intercept(context);
        }
        return context;
    }

    public InterceptorContext executeResponse(InterceptorContext context) throws ApiException {
        for (ResponseInterceptor interceptor : this.responseInterceptors) {
            context = interceptor.intercept(context);
        }
        return context;
    }
}

