/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TableJiraRenderer
implements NodeRenderer {
    public TableJiraRenderer(DataHolder options) {
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(TableBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<TableBlock>(){

            public void render(TableBlock node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(TableHead.class, (CustomNodeRenderer)new CustomNodeRenderer<TableHead>(){

            public void render(TableHead node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(TableSeparator.class, (CustomNodeRenderer)new CustomNodeRenderer<TableSeparator>(){

            public void render(TableSeparator node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(TableBody.class, (CustomNodeRenderer)new CustomNodeRenderer<TableBody>(){

            public void render(TableBody node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(TableRow.class, (CustomNodeRenderer)new CustomNodeRenderer<TableRow>(){

            public void render(TableRow node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(TableCell.class, (CustomNodeRenderer)new CustomNodeRenderer<TableCell>(){

            public void render(TableCell node, NodeRendererContext context, HtmlWriter html) {
                TableJiraRenderer.this.render(node, context, html);
            }
        })));
    }

    private HtmlWriter tailBlankLine(Node node, HtmlWriter html) {
        return this.tailBlankLine(node, 1, html);
    }

    public boolean isLastBlockQuoteChild(Node node) {
        Node parent = node.getParent();
        return parent instanceof BlockQuote && parent.getLastChild() == node;
    }

    public HtmlWriter tailBlankLine(Node node, int count, HtmlWriter html) {
        if (this.isLastBlockQuoteChild(node)) {
            CharSequence prefix = html.getPrefix();
            html.popPrefix();
            html.blankLine(count);
            html.pushPrefix();
            html.setPrefix(prefix, false);
        } else {
            html.blankLine(count);
        }
        return html;
    }

    private void render(TableBlock node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
        this.tailBlankLine((Node)node, html);
    }

    private void render(TableHead node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(TableSeparator tableSeparator, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(TableBody node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(TableRow node, NodeRendererContext context, HtmlWriter html) {
        if (node.getParent() instanceof TableHead) {
            ((HtmlWriter)html.line()).raw((CharSequence)"||");
        } else if (node.getParent() instanceof TableBody) {
            ((HtmlWriter)html.line()).raw((CharSequence)"|");
        }
        context.renderChildren((Node)node);
        html.line();
    }

    private void render(TableCell node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
        if (node.getParent().getParent() instanceof TableHead) {
            html.raw((CharSequence)"||");
        } else if (node.getParent().getParent() instanceof TableBody) {
            html.raw((CharSequence)"|");
        }
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer apply(DataHolder options) {
            return new TableJiraRenderer(options);
        }
    }
}

