/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util.sqlcontainer;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.ContainerHelpers;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.filter.Compare;
import com.vaadin.v7.data.util.filter.Like;
import com.vaadin.v7.data.util.filter.UnsupportedFilterException;
import com.vaadin.v7.data.util.sqlcontainer.CacheFlushNotifier;
import com.vaadin.v7.data.util.sqlcontainer.CacheMap;
import com.vaadin.v7.data.util.sqlcontainer.ColumnProperty;
import com.vaadin.v7.data.util.sqlcontainer.OptimisticLockException;
import com.vaadin.v7.data.util.sqlcontainer.ReadOnlyRowId;
import com.vaadin.v7.data.util.sqlcontainer.Reference;
import com.vaadin.v7.data.util.sqlcontainer.RowId;
import com.vaadin.v7.data.util.sqlcontainer.RowItem;
import com.vaadin.v7.data.util.sqlcontainer.TemporaryRowId;
import com.vaadin.v7.data.util.sqlcontainer.query.OrderBy;
import com.vaadin.v7.data.util.sqlcontainer.query.QueryDelegate;
import com.vaadin.v7.data.util.sqlcontainer.query.TableQuery;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.MSSQLGenerator;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.OracleGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class SQLContainer
implements Container,
Container.Filterable,
Container.Indexed,
Container.Sortable,
Container.ItemSetChangeNotifier {
    private QueryDelegate queryDelegate;
    private boolean autoCommit = false;
    private int pageLength;
    public static final int DEFAULT_PAGE_LENGTH = 100;
    public static final int CACHE_RATIO = 2;
    private int cacheOverlap = this.pageLength = 100;
    private final Map<Integer, RowId> itemIndexes = new HashMap<Integer, RowId>();
    private final CacheMap<RowId, RowItem> cachedItems = new CacheMap();
    private final List<String> propertyIds = new ArrayList<String>();
    private final Map<String, Class<?>> propertyTypes = new HashMap();
    private final Map<String, Boolean> propertyReadOnly = new HashMap<String, Boolean>();
    private final Map<String, Boolean> propertyPersistable = new HashMap<String, Boolean>();
    private final Map<String, Boolean> propertyNullable = new HashMap<String, Boolean>();
    private final Map<String, Boolean> propertyPrimaryKey = new HashMap<String, Boolean>();
    private final List<Container.Filter> filters = new ArrayList<Container.Filter>();
    private final List<OrderBy> sorters = new ArrayList<OrderBy>();
    private int size;
    private final int sizeValidMilliSeconds = 10000;
    private boolean sizeDirty = true;
    private Date sizeUpdated = new Date();
    private int currentOffset;
    private LinkedList<Container.ItemSetChangeListener> itemSetChangeListeners;
    private final Map<RowId, RowItem> removedItems = new HashMap<RowId, RowItem>();
    private final List<RowItem> addedItems = new ArrayList<RowItem>();
    private final List<RowItem> modifiedItems = new ArrayList<RowItem>();
    private final Map<SQLContainer, Reference> references = new HashMap<SQLContainer, Reference>();
    private boolean notificationsEnabled;

    private SQLContainer() {
    }

    public SQLContainer(QueryDelegate delegate) throws SQLException {
        if (delegate == null) {
            throw new IllegalArgumentException("QueryDelegate must not be null.");
        }
        this.queryDelegate = delegate;
        this.getPropertyIds();
        this.cachedItems.setCacheLimit(2 * this.getPageLength() + this.cacheOverlap);
    }

    @Override
    public Object addItem() throws UnsupportedOperationException {
        Object[] emptyKey = new Object[this.queryDelegate.getPrimaryKeyColumns().size()];
        RowId itemId = new TemporaryRowId(emptyKey);
        ArrayList<ColumnProperty> itemProperties = new ArrayList<ColumnProperty>();
        for (String propertyId : this.propertyIds) {
            ColumnProperty cp = new ColumnProperty(propertyId, this.propertyReadOnly.get(propertyId), this.propertyPersistable.get(propertyId), this.propertyNullable.get(propertyId), this.propertyPrimaryKey.get(propertyId), null, this.getType(propertyId));
            itemProperties.add(cp);
        }
        RowItem newRowItem = new RowItem(this, itemId, itemProperties);
        if (this.autoCommit) {
            try {
                if (this.queryDelegate instanceof TableQuery) {
                    itemId = ((TableQuery)this.queryDelegate).storeRowImmediately(newRowItem);
                } else {
                    this.queryDelegate.beginTransaction();
                    this.queryDelegate.storeRow(newRowItem);
                    this.queryDelegate.commit();
                }
                this.refresh();
                if (this.notificationsEnabled) {
                    CacheFlushNotifier.notifyOfCacheFlush(this);
                }
                SQLContainer.getLogger().log(Level.FINER, "Row added to DB...");
                return itemId;
            }
            catch (SQLException e) {
                SQLContainer.getLogger().log(Level.WARNING, "Failed to add row to DB. Rolling back.", e);
                try {
                    this.queryDelegate.rollback();
                }
                catch (SQLException ee) {
                    SQLContainer.getLogger().log(Level.SEVERE, "Failed to roll back row addition", e);
                }
                return null;
            }
        }
        this.addedItems.add(newRowItem);
        this.fireContentsChange();
        return itemId;
    }

    @Override
    public boolean containsId(Object itemId) {
        if (itemId == null) {
            return false;
        }
        if (this.cachedItems.containsKey(itemId)) {
            return true;
        }
        for (RowItem item : this.addedItems) {
            if (!item.getId().equals(itemId)) continue;
            return this.itemPassesFilters(item);
        }
        if (this.removedItems.containsKey(itemId)) {
            return false;
        }
        if (itemId instanceof ReadOnlyRowId) {
            int rowNum = ((ReadOnlyRowId)itemId).getRowNum();
            return rowNum >= 0 && rowNum < this.size;
        }
        if (itemId instanceof RowId && !(itemId instanceof TemporaryRowId)) {
            try {
                return this.queryDelegate.containsRowWithKey(((RowId)itemId).getId());
            }
            catch (Exception e) {
                SQLContainer.getLogger().log(Level.WARNING, "containsId query failed", e);
            }
        }
        return false;
    }

    @Override
    public Property getContainerProperty(Object itemId, Object propertyId) {
        Item item = this.getItem(itemId);
        if (item == null) {
            return null;
        }
        return item.getItemProperty(propertyId);
    }

    @Override
    public Collection<?> getContainerPropertyIds() {
        return Collections.unmodifiableCollection(this.propertyIds);
    }

    @Override
    public Item getItem(Object itemId) {
        if (!this.cachedItems.containsKey(itemId)) {
            int index = this.indexOfId(itemId);
            if (index >= this.size) {
                int offset = index - this.size;
                RowItem item = this.addedItems.get(offset);
                if (this.itemPassesFilters(item)) {
                    return item;
                }
                return null;
            }
            this.updateOffsetAndCache(index);
        }
        return (Item)this.cachedItems.get(itemId);
    }

    public Item getItemUnfiltered(Object itemId) {
        if (!this.cachedItems.containsKey(itemId)) {
            for (RowItem item : this.addedItems) {
                if (!item.getId().equals(itemId)) continue;
                return item;
            }
        }
        return (Item)this.cachedItems.get(itemId);
    }

    @Override
    public Collection<?> getItemIds() {
        this.updateCount();
        ArrayList<RowId> ids = new ArrayList<RowId>();
        ResultSet rs = null;
        try {
            this.queryDelegate.beginTransaction();
            rs = this.queryDelegate.getResults(0, 0);
            List<String> pKeys = this.queryDelegate.getPrimaryKeyColumns();
            while (rs.next()) {
                RowId id = null;
                if (pKeys.isEmpty()) {
                    id = new ReadOnlyRowId(rs.getRow());
                } else {
                    Object[] itemId = new Object[pKeys.size()];
                    for (int i = 0; i < pKeys.size(); ++i) {
                        itemId[i] = rs.getObject(pKeys.get(i));
                    }
                    id = new RowId(itemId);
                }
                if (id == null || this.removedItems.containsKey(id)) continue;
                ids.add(id);
            }
            rs.getStatement().close();
            rs.close();
            this.queryDelegate.commit();
        }
        catch (SQLException e) {
            SQLContainer.getLogger().log(Level.WARNING, "getItemIds() failed, rolling back.", e);
            try {
                this.queryDelegate.rollback();
            }
            catch (SQLException e1) {
                SQLContainer.getLogger().log(Level.SEVERE, "Failed to roll back state", e1);
            }
            try {
                rs.getStatement().close();
                rs.close();
            }
            catch (SQLException e1) {
                SQLContainer.getLogger().log(Level.WARNING, "Closing session failed", e1);
            }
            throw new RuntimeException("Failed to fetch item indexes.", e);
        }
        for (RowItem item : this.getFilteredAddedItems()) {
            ids.add(item.getId());
        }
        return Collections.unmodifiableCollection(ids);
    }

    @Override
    public Class<?> getType(Object propertyId) {
        if (!this.propertyIds.contains(propertyId)) {
            return null;
        }
        return this.propertyTypes.get(propertyId);
    }

    @Override
    public int size() {
        this.updateCount();
        return this.size + this.sizeOfAddedItems() - this.removedItems.size();
    }

    @Override
    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        if (!this.containsId(itemId)) {
            return false;
        }
        for (RowItem item : this.addedItems) {
            if (!item.getId().equals(itemId)) continue;
            this.addedItems.remove(item);
            this.fireContentsChange();
            return true;
        }
        if (this.autoCommit) {
            Item i = this.getItem(itemId);
            if (i == null) {
                return false;
            }
            try {
                this.queryDelegate.beginTransaction();
                boolean success = this.queryDelegate.removeRow((RowItem)i);
                this.queryDelegate.commit();
                this.refresh();
                if (this.notificationsEnabled) {
                    CacheFlushNotifier.notifyOfCacheFlush(this);
                }
                if (success) {
                    SQLContainer.getLogger().log(Level.FINER, "Row removed from DB...");
                }
                return success;
            }
            catch (SQLException e) {
                SQLContainer.getLogger().log(Level.WARNING, "Failed to remove row, rolling back", e);
                try {
                    this.queryDelegate.rollback();
                }
                catch (SQLException ee) {
                    SQLContainer.getLogger().log(Level.SEVERE, "Failed to rollback row removal", ee);
                }
                return false;
            }
            catch (OptimisticLockException e) {
                SQLContainer.getLogger().log(Level.WARNING, "Failed to remove row, rolling back", e);
                try {
                    this.queryDelegate.rollback();
                }
                catch (SQLException ee) {
                    SQLContainer.getLogger().log(Level.SEVERE, "Failed to rollback row removal", ee);
                }
                throw e;
            }
        }
        this.removedItems.put((RowId)itemId, (RowItem)this.getItem(itemId));
        this.cachedItems.remove(itemId);
        this.refresh();
        return true;
    }

    @Override
    public boolean removeAllItems() throws UnsupportedOperationException {
        if (this.autoCommit) {
            try {
                this.queryDelegate.beginTransaction();
                boolean success = true;
                for (Object id : this.getItemIds()) {
                    if (this.queryDelegate.removeRow((RowItem)this.getItem(id))) continue;
                    success = false;
                }
                if (success) {
                    this.queryDelegate.commit();
                    SQLContainer.getLogger().log(Level.FINER, "All rows removed from DB...");
                    this.refresh();
                    if (this.notificationsEnabled) {
                        CacheFlushNotifier.notifyOfCacheFlush(this);
                    }
                } else {
                    this.queryDelegate.rollback();
                }
                return success;
            }
            catch (SQLException e) {
                SQLContainer.getLogger().log(Level.WARNING, "removeAllItems() failed, rolling back", e);
                try {
                    this.queryDelegate.rollback();
                }
                catch (SQLException ee) {
                    SQLContainer.getLogger().log(Level.SEVERE, "Failed to roll back", ee);
                }
                return false;
            }
            catch (OptimisticLockException e) {
                SQLContainer.getLogger().log(Level.WARNING, "removeAllItems() failed, rolling back", e);
                try {
                    this.queryDelegate.rollback();
                }
                catch (SQLException ee) {
                    SQLContainer.getLogger().log(Level.SEVERE, "Failed to roll back", ee);
                }
                throw e;
            }
        }
        for (Object id : this.getItemIds()) {
            this.removedItems.put((RowId)id, (RowItem)this.getItem(id));
            this.cachedItems.remove(id);
        }
        this.refresh();
        return true;
    }

    @Override
    public void addContainerFilter(Container.Filter filter) throws UnsupportedFilterException {
        this.filters.add(filter);
        this.refresh();
    }

    @Override
    public void removeContainerFilter(Container.Filter filter) {
        this.filters.remove(filter);
        this.refresh();
    }

    public void addContainerFilter(Object propertyId, String filterString, boolean ignoreCase, boolean onlyMatchPrefix) {
        if (propertyId == null || !this.propertyIds.contains(propertyId)) {
            return;
        }
        String likeStr = onlyMatchPrefix ? filterString + "%" : "%" + filterString + "%";
        Like like = new Like(propertyId.toString(), likeStr);
        like.setCaseSensitive(!ignoreCase);
        this.filters.add(like);
        this.refresh();
    }

    public void removeContainerFilters(Object propertyId) {
        ArrayList<Container.Filter> toRemove = new ArrayList<Container.Filter>();
        for (Container.Filter f : this.filters) {
            if (!f.appliesToProperty(propertyId)) continue;
            toRemove.add(f);
        }
        this.filters.removeAll(toRemove);
        this.refresh();
    }

    @Override
    public void removeAllContainerFilters() {
        this.filters.clear();
        this.refresh();
    }

    public boolean hasContainerFilters() {
        return !this.getContainerFilters().isEmpty();
    }

    @Override
    public Collection<Container.Filter> getContainerFilters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    @Override
    public int indexOfId(Object itemId) {
        for (int ix = 0; ix < this.addedItems.size(); ++ix) {
            RowItem item = this.addedItems.get(ix);
            if (!item.getId().equals(itemId)) continue;
            if (this.itemPassesFilters(item)) {
                this.updateCount();
                return this.size + ix;
            }
            return -1;
        }
        if (!this.containsId(itemId)) {
            return -1;
        }
        if (this.cachedItems.isEmpty()) {
            this.getPage();
        }
        int counter = 0;
        while (counter < this.size) {
            if (this.itemIndexes.containsValue(itemId)) {
                for (Integer idx : this.itemIndexes.keySet()) {
                    if (!this.itemIndexes.get(idx).equals(itemId)) continue;
                    return idx;
                }
            }
            int oldIndex = this.currentOffset;
            int nextIndex = this.currentOffset + this.pageLength * 2 + this.cacheOverlap;
            if (nextIndex >= this.size) {
                nextIndex = 0;
            }
            this.updateOffsetAndCache(nextIndex);
            if (this.currentOffset > oldIndex) {
                counter += this.currentOffset - oldIndex;
                continue;
            }
            counter += this.size - oldIndex;
        }
        return -1;
    }

    @Override
    public Object getIdByIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index is negative! index=" + index);
        }
        this.updateCount();
        if (index < this.size) {
            if (this.itemIndexes.keySet().contains(index)) {
                return this.itemIndexes.get(index);
            }
            this.updateOffsetAndCache(index);
            return this.itemIndexes.get(index);
        }
        int offset = index - this.size;
        return this.getFilteredAddedItems().get(offset).getId();
    }

    public List<Object> getItemIds(int startIndex, int numberOfIds) {
        return ContainerHelpers.getItemIdsUsingGetIdByIndex(startIndex, numberOfIds, this);
    }

    @Override
    public Object nextItemId(Object itemId) {
        int index = this.indexOfId(itemId) + 1;
        try {
            return this.getIdByIndex(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public Object prevItemId(Object itemId) {
        int prevIndex = this.indexOfId(itemId) - 1;
        try {
            return this.getIdByIndex(prevIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public Object firstItemId() {
        this.updateCount();
        if (this.size == 0) {
            if (this.addedItems.isEmpty()) {
                return null;
            }
            int ix = -1;
            while (!this.itemPassesFilters(this.addedItems.get(++ix)) && ix < this.addedItems.size()) {
            }
            if (ix < this.addedItems.size()) {
                return this.addedItems.get(ix).getId();
            }
        }
        if (!this.itemIndexes.containsKey(0)) {
            this.updateOffsetAndCache(0);
        }
        return this.itemIndexes.get(0);
    }

    @Override
    public Object lastItemId() {
        if (this.addedItems.isEmpty()) {
            int lastIx = this.size() - 1;
            if (!this.itemIndexes.containsKey(lastIx)) {
                this.updateOffsetAndCache(this.size - 1);
            }
            return this.itemIndexes.get(lastIx);
        }
        int ix = this.addedItems.size();
        while (!this.itemPassesFilters(this.addedItems.get(--ix)) && ix >= 0) {
        }
        if (ix >= 0) {
            return this.addedItems.get(ix).getId();
        }
        return null;
    }

    @Override
    public boolean isFirstId(Object itemId) {
        return this.firstItemId().equals(itemId);
    }

    @Override
    public boolean isLastId(Object itemId) {
        return this.lastItemId().equals(itemId);
    }

    @Override
    public void sort(Object[] propertyId, boolean[] ascending) {
        this.sorters.clear();
        if (propertyId == null || propertyId.length == 0) {
            this.refresh();
            return;
        }
        boolean asc = true;
        for (int i = 0; i < propertyId.length; ++i) {
            if (!(propertyId[i] instanceof String) || !this.propertyIds.contains(propertyId[i])) continue;
            try {
                asc = ascending[i];
            }
            catch (Exception e) {
                SQLContainer.getLogger().log(Level.WARNING, "", e);
            }
            this.sorters.add(new OrderBy((String)propertyId[i], asc));
        }
        this.refresh();
    }

    @Override
    public Collection<?> getSortableContainerPropertyIds() {
        return this.getContainerPropertyIds();
    }

    public void refresh() {
        this.refresh(true);
    }

    private void refresh(boolean setSizeDirty) {
        if (setSizeDirty) {
            this.sizeDirty = true;
        }
        this.currentOffset = 0;
        this.cachedItems.clear();
        this.itemIndexes.clear();
        this.fireContentsChange();
    }

    public boolean isModified() {
        return !this.removedItems.isEmpty() || !this.addedItems.isEmpty() || !this.modifiedItems.isEmpty();
    }

    public void setAutoCommit(boolean autoCommitEnabled) {
        this.autoCommit = autoCommitEnabled;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public void setPageLength(int pageLength) {
        this.setPageLengthInternal(pageLength);
        this.refresh();
    }

    private void setPageLengthInternal(int pageLength) {
        this.pageLength = pageLength > 0 ? pageLength : 100;
        this.cacheOverlap = this.getPageLength();
        this.cachedItems.setCacheLimit(2 * this.getPageLength() + this.cacheOverlap);
    }

    public void addOrderBy(OrderBy orderBy) {
        if (orderBy == null) {
            return;
        }
        if (!this.propertyIds.contains(orderBy.getColumn())) {
            throw new IllegalArgumentException("The column given for sorting does not exist in this container.");
        }
        this.sorters.add(orderBy);
        this.refresh();
    }

    public void commit() throws UnsupportedOperationException, SQLException {
        try {
            SQLContainer.getLogger().log(Level.FINER, "Commiting changes through delegate...");
            this.queryDelegate.beginTransaction();
            for (RowItem item : this.removedItems.values()) {
                try {
                    if (this.queryDelegate.removeRow(item)) continue;
                    throw new SQLException("Removal failed for row with ID: " + item.getId());
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException("Removal failed for row with ID: " + item.getId(), e);
                }
            }
            for (RowItem item : this.modifiedItems) {
                if (this.removedItems.containsKey(item.getId())) continue;
                if (this.queryDelegate.storeRow(item) > 0) {
                    item.commit();
                    continue;
                }
                this.queryDelegate.rollback();
                this.refresh();
                throw new ConcurrentModificationException("Item with the ID '" + item.getId() + "' has been externally modified.");
            }
            for (RowItem item : this.addedItems) {
                this.queryDelegate.storeRow(item);
            }
            this.queryDelegate.commit();
            this.removedItems.clear();
            this.addedItems.clear();
            this.modifiedItems.clear();
            this.refresh();
            if (this.notificationsEnabled) {
                CacheFlushNotifier.notifyOfCacheFlush(this);
            }
        }
        catch (SQLException e) {
            this.queryDelegate.rollback();
            throw e;
        }
        catch (OptimisticLockException e) {
            this.queryDelegate.rollback();
            throw e;
        }
    }

    public void rollback() throws UnsupportedOperationException, SQLException {
        SQLContainer.getLogger().log(Level.FINE, "Rolling back changes...");
        this.removedItems.clear();
        this.addedItems.clear();
        this.modifiedItems.clear();
        this.refresh();
    }

    void itemChangeNotification(RowItem changedItem) {
        if (this.autoCommit) {
            try {
                this.queryDelegate.beginTransaction();
                if (this.queryDelegate.storeRow(changedItem) == 0) {
                    this.queryDelegate.rollback();
                    this.refresh();
                    throw new ConcurrentModificationException("Item with the ID '" + changedItem.getId() + "' has been externally modified.");
                }
                this.queryDelegate.commit();
                if (this.notificationsEnabled) {
                    CacheFlushNotifier.notifyOfCacheFlush(this);
                }
                SQLContainer.getLogger().log(Level.FINER, "Row updated to DB...");
            }
            catch (SQLException e) {
                SQLContainer.getLogger().log(Level.WARNING, "itemChangeNotification failed, rolling back...", e);
                try {
                    this.queryDelegate.rollback();
                }
                catch (SQLException ee) {
                    SQLContainer.getLogger().log(Level.SEVERE, "Rollback failed", e);
                }
                throw new RuntimeException(e);
            }
        }
        if (!(changedItem.getId() instanceof TemporaryRowId) && !this.modifiedItems.contains(changedItem)) {
            this.modifiedItems.add(changedItem);
        }
    }

    private void updateOffsetAndCache(int index) {
        int oldOffset = this.currentOffset;
        this.currentOffset = index / this.pageLength * this.pageLength - this.cacheOverlap;
        if (this.currentOffset < 0) {
            this.currentOffset = 0;
        }
        if (oldOffset == this.currentOffset && !this.cachedItems.isEmpty()) {
            return;
        }
        this.getPage();
    }

    private void updateCount() {
        if (!this.sizeDirty && new Date().getTime() < this.sizeUpdated.getTime() + 10000L) {
            return;
        }
        try {
            try {
                this.queryDelegate.setFilters(this.filters);
            }
            catch (UnsupportedOperationException e) {
                SQLContainer.getLogger().log(Level.FINE, "The query delegate doesn't support filtering", e);
            }
            try {
                this.queryDelegate.setOrderBy(this.sorters);
            }
            catch (UnsupportedOperationException e) {
                SQLContainer.getLogger().log(Level.FINE, "The query delegate doesn't support sorting", e);
            }
            int newSize = this.queryDelegate.getCount();
            this.sizeUpdated = new Date();
            this.sizeDirty = false;
            if (newSize != this.size) {
                this.size = newSize;
                this.refresh(false);
            }
            SQLContainer.getLogger().log(Level.FINER, "Updated row count. New count is: {0}", this.size);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to update item set size.", e);
        }
    }

    private void getPropertyIds() throws SQLException {
        this.propertyIds.clear();
        this.propertyTypes.clear();
        this.queryDelegate.setFilters(null);
        this.queryDelegate.setOrderBy(null);
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        try {
            this.queryDelegate.beginTransaction();
            rs = this.queryDelegate.getResults(0, 1);
            rsmd = rs.getMetaData();
            boolean resultExists = rs.next();
            Class<Object> type = null;
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                boolean persistable;
                if (!this.isColumnIdentifierValid(rsmd.getColumnLabel(i))) continue;
                String colName = rsmd.getColumnLabel(i);
                if (!this.propertyIds.contains(colName)) {
                    this.propertyIds.add(colName);
                }
                if (resultExists && rs.getObject(i) != null) {
                    type = rs.getObject(i).getClass();
                } else {
                    try {
                        type = Class.forName(rsmd.getColumnClassName(i));
                    }
                    catch (Exception e) {
                        SQLContainer.getLogger().log(Level.WARNING, "Class not found", e);
                        type = Object.class;
                    }
                }
                boolean readOnly = rsmd.isAutoIncrement(i) || rsmd.isReadOnly(i);
                boolean bl = persistable = !rsmd.isReadOnly(i);
                if (this.queryDelegate instanceof TableQuery && rsmd.getColumnLabel(i).equals(((TableQuery)this.queryDelegate).getVersionColumn())) {
                    readOnly = true;
                }
                this.propertyReadOnly.put(colName, readOnly);
                this.propertyPersistable.put(colName, persistable);
                this.propertyNullable.put(colName, rsmd.isNullable(i) == 1);
                this.propertyPrimaryKey.put(colName, this.queryDelegate.getPrimaryKeyColumns().contains(rsmd.getColumnLabel(i)));
                this.propertyTypes.put(colName, type);
            }
            rs.getStatement().close();
            rs.close();
            this.queryDelegate.commit();
            SQLContainer.getLogger().log(Level.FINER, "Property IDs fetched.");
        }
        catch (SQLException e) {
            SQLContainer.getLogger().log(Level.WARNING, "Failed to fetch property ids, rolling back", e);
            try {
                this.queryDelegate.rollback();
            }
            catch (SQLException e1) {
                SQLContainer.getLogger().log(Level.SEVERE, "Failed to roll back", e1);
            }
            try {
                if (rs != null) {
                    if (rs.getStatement() != null) {
                        rs.getStatement().close();
                    }
                    rs.close();
                }
            }
            catch (SQLException e1) {
                SQLContainer.getLogger().log(Level.WARNING, "Failed to close session", e1);
            }
            throw e;
        }
    }

    private void getPage() {
        this.updateCount();
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        this.cachedItems.clear();
        this.itemIndexes.clear();
        try {
            try {
                this.queryDelegate.setOrderBy(this.sorters);
            }
            catch (UnsupportedOperationException e) {
                SQLContainer.getLogger().log(Level.FINE, "The query delegate doesn't support sorting", e);
            }
            this.queryDelegate.beginTransaction();
            int fetchedRows = this.pageLength * 2 + this.cacheOverlap;
            rs = this.queryDelegate.getResults(this.currentOffset, fetchedRows);
            rsmd = rs.getMetaData();
            List<String> pKeys = this.queryDelegate.getPrimaryKeyColumns();
            ColumnProperty cp = null;
            int rowCount = this.currentOffset;
            if (!this.queryDelegate.implementationRespectsPagingLimits()) {
                this.currentOffset = 0;
                rowCount = 0;
                this.setPageLengthInternal(this.size);
            }
            while (rs.next()) {
                ArrayList<ColumnProperty> itemProperties = new ArrayList<ColumnProperty>();
                Object[] itemId = new Object[pKeys.size()];
                for (int i = 0; i < pKeys.size(); ++i) {
                    itemId[i] = rs.getObject(pKeys.get(i));
                }
                RowId id = null;
                id = pKeys.isEmpty() ? new ReadOnlyRowId(rs.getRow()) : new RowId(itemId);
                ArrayList<String> propertiesToAdd = new ArrayList<String>(this.propertyIds);
                if (this.removedItems.containsKey(id)) continue;
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    Class type;
                    if (!this.isColumnIdentifierValid(rsmd.getColumnLabel(i))) continue;
                    String colName = rsmd.getColumnLabel(i);
                    Object value = rs.getObject(i);
                    Class clazz = type = value != null ? value.getClass() : Object.class;
                    if (value == null) {
                        for (String propName : this.propertyTypes.keySet()) {
                            if (!propName.equals(rsmd.getColumnLabel(i))) continue;
                            type = this.propertyTypes.get(propName);
                            break;
                        }
                    }
                    if (!propertiesToAdd.contains(colName)) continue;
                    cp = new ColumnProperty(colName, this.propertyReadOnly.get(colName), this.propertyPersistable.get(colName), this.propertyNullable.get(colName), this.propertyPrimaryKey.get(colName), value, type);
                    itemProperties.add(cp);
                    propertiesToAdd.remove(colName);
                }
                this.itemIndexes.put(rowCount, id);
                int modifiedIndex = this.indexInModifiedCache(id);
                if (modifiedIndex != -1) {
                    this.cachedItems.put(id, this.modifiedItems.get(modifiedIndex));
                } else {
                    this.cachedItems.put(id, new RowItem(this, id, itemProperties));
                }
                ++rowCount;
            }
            rs.getStatement().close();
            rs.close();
            this.queryDelegate.commit();
            SQLContainer.getLogger().log(Level.FINER, "Fetched {0} rows starting from {1}", new Object[]{fetchedRows, this.currentOffset});
        }
        catch (SQLException e) {
            SQLContainer.getLogger().log(Level.WARNING, "Failed to fetch rows, rolling back", e);
            try {
                this.queryDelegate.rollback();
            }
            catch (SQLException e1) {
                SQLContainer.getLogger().log(Level.SEVERE, "Failed to roll back", e1);
            }
            try {
                if (rs != null && rs.getStatement() != null) {
                    rs.getStatement().close();
                    rs.close();
                }
            }
            catch (SQLException e1) {
                SQLContainer.getLogger().log(Level.WARNING, "Failed to close session", e1);
            }
            throw new RuntimeException("Failed to fetch page.", e);
        }
    }

    private int indexInModifiedCache(Object itemId) {
        for (int ix = 0; ix < this.modifiedItems.size(); ++ix) {
            RowItem item = this.modifiedItems.get(ix);
            if (!item.getId().equals(itemId)) continue;
            return ix;
        }
        return -1;
    }

    private int sizeOfAddedItems() {
        return this.getFilteredAddedItems().size();
    }

    private List<RowItem> getFilteredAddedItems() {
        ArrayList<RowItem> filtered = new ArrayList<RowItem>(this.addedItems);
        if (this.filters != null && !this.filters.isEmpty()) {
            for (RowItem item : this.addedItems) {
                if (this.itemPassesFilters(item)) continue;
                filtered.remove(item);
            }
        }
        return filtered;
    }

    private boolean itemPassesFilters(RowItem item) {
        for (Container.Filter filter : this.filters) {
            if (filter.passesFilter(item.getId(), item)) continue;
            return false;
        }
        return true;
    }

    private boolean isColumnIdentifierValid(String identifier) {
        TableQuery tq;
        return !identifier.equalsIgnoreCase("rownum") || !(this.queryDelegate instanceof TableQuery) || !((tq = (TableQuery)this.queryDelegate).getSqlGenerator() instanceof MSSQLGenerator) && !(tq.getSqlGenerator() instanceof OracleGenerator);
    }

    protected QueryDelegate getQueryDelegate() {
        return this.queryDelegate;
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item addItem(Object itemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item addItemAfter(Object previousItemId, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item addItemAt(int index, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object addItemAt(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object addItemAfter(Object previousItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.itemSetChangeListeners == null) {
            this.itemSetChangeListeners = new LinkedList();
        }
        this.itemSetChangeListeners.add(listener);
    }

    @Override
    @Deprecated
    public void addListener(Container.ItemSetChangeListener listener) {
        this.addItemSetChangeListener(listener);
    }

    @Override
    public void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.itemSetChangeListeners != null) {
            this.itemSetChangeListeners.remove(listener);
        }
    }

    @Override
    @Deprecated
    public void removeListener(Container.ItemSetChangeListener listener) {
        this.removeItemSetChangeListener(listener);
    }

    protected void fireContentsChange() {
        if (this.itemSetChangeListeners != null) {
            Object[] l = this.itemSetChangeListeners.toArray();
            ItemSetChangeEvent event = new ItemSetChangeEvent(this);
            for (int i = 0; i < l.length; ++i) {
                ((Container.ItemSetChangeListener)l[i]).containerItemSetChange(event);
            }
        }
    }

    public void addRowIdChangeListener(QueryDelegate.RowIdChangeListener listener) {
        if (this.queryDelegate instanceof QueryDelegate.RowIdChangeNotifier) {
            ((QueryDelegate.RowIdChangeNotifier)((Object)this.queryDelegate)).addListener(listener);
        }
    }

    @Deprecated
    public void addListener(QueryDelegate.RowIdChangeListener listener) {
        this.addRowIdChangeListener(listener);
    }

    public void removeRowIdChangeListener(QueryDelegate.RowIdChangeListener listener) {
        if (this.queryDelegate instanceof QueryDelegate.RowIdChangeNotifier) {
            ((QueryDelegate.RowIdChangeNotifier)((Object)this.queryDelegate)).removeListener(listener);
        }
    }

    @Deprecated
    public void removeListener(QueryDelegate.RowIdChangeListener listener) {
        this.removeRowIdChangeListener(listener);
    }

    public void enableCacheFlushNotifications() {
        if (!this.notificationsEnabled) {
            this.notificationsEnabled = true;
            CacheFlushNotifier.addInstance(this);
        }
    }

    public void addReference(SQLContainer refdCont, String refingCol, String refdCol) {
        if (refdCont == null) {
            throw new IllegalArgumentException("Referenced SQLContainer can not be null.");
        }
        if (!this.getContainerPropertyIds().contains(refingCol)) {
            throw new IllegalArgumentException("Given referencing column name is invalid. Please ensure that this container contains a property ID named: " + refingCol);
        }
        if (!refdCont.getContainerPropertyIds().contains(refdCol)) {
            throw new IllegalArgumentException("Given referenced column name is invalid. Please ensure that the referenced container contains a property ID named: " + refdCol);
        }
        if (this.references.keySet().contains(refdCont)) {
            throw new IllegalArgumentException("An SQLContainer instance can only be referenced once.");
        }
        this.references.put(refdCont, new Reference(refdCont, refingCol, refdCol));
    }

    public boolean removeReference(SQLContainer refdCont) {
        if (refdCont == null) {
            throw new IllegalArgumentException("Referenced SQLContainer can not be null.");
        }
        return this.references.remove(refdCont) != null;
    }

    public boolean setReferencedItem(Object itemId, Object refdItemId, SQLContainer refdCont) {
        if (refdCont == null) {
            throw new IllegalArgumentException("Referenced SQLContainer can not be null.");
        }
        Reference r = this.references.get(refdCont);
        if (r == null) {
            throw new IllegalArgumentException("Reference to the given SQLContainer not defined.");
        }
        try {
            this.getContainerProperty(itemId, r.getReferencingColumn()).setValue(refdCont.getContainerProperty(refdItemId, r.getReferencedColumn()));
            return true;
        }
        catch (Exception e) {
            SQLContainer.getLogger().log(Level.WARNING, "Setting referenced item failed.", e);
            return false;
        }
    }

    public Object getReferencedItemId(Object itemId, SQLContainer refdCont) {
        if (refdCont == null) {
            throw new IllegalArgumentException("Referenced SQLContainer can not be null.");
        }
        Reference r = this.references.get(refdCont);
        if (r == null) {
            throw new IllegalArgumentException("Reference to the given SQLContainer not defined.");
        }
        Object refKey = this.getContainerProperty(itemId, r.getReferencingColumn()).getValue();
        refdCont.removeAllContainerFilters();
        refdCont.addContainerFilter(new Compare.Equal(r.getReferencedColumn(), refKey));
        Object toReturn = refdCont.firstItemId();
        refdCont.removeAllContainerFilters();
        return toReturn;
    }

    public Item getReferencedItem(Object itemId, SQLContainer refdCont) {
        return refdCont.getItem(this.getReferencedItemId(itemId, refdCont));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.notificationsEnabled) {
            CacheFlushNotifier.addInstance(this);
        }
    }

    private static final Logger getLogger() {
        return Logger.getLogger(SQLContainer.class.getName());
    }

    @Deprecated
    public static class ItemSetChangeEvent
    extends EventObject
    implements Container.ItemSetChangeEvent {
        private ItemSetChangeEvent(SQLContainer source) {
            super(source);
        }

        @Override
        public Container getContainer() {
            return (Container)this.getSource();
        }
    }
}

