/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util.filter;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;

@Deprecated
public abstract class Compare
implements Container.Filter {
    private final Object propertyId;
    private final Operation operation;
    private final Object value;

    Compare(Object propertyId, Object value, Operation operation) {
        this.propertyId = propertyId;
        this.value = value;
        this.operation = operation;
    }

    @Override
    public boolean passesFilter(Object itemId, Item item) {
        Property p = item.getItemProperty(this.getPropertyId());
        if (null == p) {
            return false;
        }
        Object value = p.getValue();
        switch (this.getOperation()) {
            case EQUAL: {
                return this.compareEquals(value);
            }
            case GREATER: {
                return this.compareValue(value) > 0;
            }
            case LESS: {
                return this.compareValue(value) < 0;
            }
            case GREATER_OR_EQUAL: {
                return this.compareValue(value) >= 0;
            }
            case LESS_OR_EQUAL: {
                return this.compareValue(value) <= 0;
            }
        }
        return false;
    }

    private boolean compareEquals(Object otherValue) {
        if (this.value == null || otherValue == null) {
            return otherValue == this.value;
        }
        if (this.value == otherValue) {
            return true;
        }
        if (this.value instanceof Comparable && otherValue.getClass().isAssignableFrom(this.getValue().getClass())) {
            return ((Comparable)this.value).compareTo(otherValue) == 0;
        }
        return this.value.equals(otherValue);
    }

    protected int compareValue(Object value1) {
        if (null == this.value) {
            return null == value1 ? 0 : -1;
        }
        if (null == value1) {
            return 1;
        }
        if (this.getValue() instanceof Comparable) {
            if (value1.getClass().isInstance(this.getValue())) {
                return -((Comparable)this.getValue()).compareTo(value1);
            }
            if (this.getValue().getClass().isInstance(value1)) {
                return ((Comparable)value1).compareTo(this.getValue());
            }
        }
        throw new IllegalArgumentException("Could not compare the arguments: " + value1 + ", " + this.getValue());
    }

    @Override
    public boolean appliesToProperty(Object propertyId) {
        return this.getPropertyId().equals(propertyId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Compare o = (Compare)obj;
        if (this.getPropertyId() != o.getPropertyId() && null != o.getPropertyId() && !o.getPropertyId().equals(this.getPropertyId())) {
            return false;
        }
        if (this.getOperation() != o.getOperation()) {
            return false;
        }
        return null == this.getValue() ? null == o.getValue() : this.getValue().equals(o.getValue());
    }

    public int hashCode() {
        return (null != this.getPropertyId() ? this.getPropertyId().hashCode() : 0) ^ (null != this.getValue() ? this.getValue().hashCode() : 0);
    }

    public Object getPropertyId() {
        return this.propertyId;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Object getValue() {
        return this.value;
    }

    @Deprecated
    public static final class LessOrEqual
    extends Compare {
        public LessOrEqual(Object propertyId, Object value) {
            super(propertyId, value, Operation.LESS_OR_EQUAL);
        }
    }

    @Deprecated
    public static final class GreaterOrEqual
    extends Compare {
        public GreaterOrEqual(Object propertyId, Object value) {
            super(propertyId, value, Operation.GREATER_OR_EQUAL);
        }
    }

    @Deprecated
    public static final class Less
    extends Compare {
        public Less(Object propertyId, Object value) {
            super(propertyId, value, Operation.LESS);
        }
    }

    @Deprecated
    public static final class Greater
    extends Compare {
        public Greater(Object propertyId, Object value) {
            super(propertyId, value, Operation.GREATER);
        }
    }

    @Deprecated
    public static final class Equal
    extends Compare {
        public Equal(Object propertyId, Object value) {
            super(propertyId, value, Operation.EQUAL);
        }
    }

    @Deprecated
    public static enum Operation {
        EQUAL,
        GREATER,
        LESS,
        GREATER_OR_EQUAL,
        LESS_OR_EQUAL;

    }
}

