/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.fieldgroup;

import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.fieldgroup.FieldGroup;
import com.vaadin.v7.data.fieldgroup.FieldGroupFieldFactory;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.AbstractTextField;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.DateField;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.InlineDateField;
import com.vaadin.v7.ui.ListSelect;
import com.vaadin.v7.ui.NativeSelect;
import com.vaadin.v7.ui.OptionGroup;
import com.vaadin.v7.ui.PopupDateField;
import com.vaadin.v7.ui.RichTextArea;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TextField;
import java.util.Date;
import java.util.EnumSet;

@Deprecated
public class DefaultFieldGroupFieldFactory
implements FieldGroupFieldFactory {
    private static final DefaultFieldGroupFieldFactory INSTANCE = new DefaultFieldGroupFieldFactory();
    public static final Object CAPTION_PROPERTY_ID = "Caption";

    protected DefaultFieldGroupFieldFactory() {
    }

    public static DefaultFieldGroupFieldFactory get() {
        return INSTANCE;
    }

    @Override
    public <T extends Field> T createField(Class<?> type, Class<T> fieldType) {
        if (Enum.class.isAssignableFrom(type)) {
            return this.createEnumField(type, fieldType);
        }
        if (Date.class.isAssignableFrom(type)) {
            return this.createDateField(type, fieldType);
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return this.createBooleanField(fieldType);
        }
        if (AbstractTextField.class.isAssignableFrom(fieldType)) {
            return (T)((Field)fieldType.cast(this.createAbstractTextField(fieldType.asSubclass(AbstractTextField.class))));
        }
        if (fieldType == RichTextArea.class) {
            return (T)((Field)fieldType.cast(this.createRichTextArea()));
        }
        return this.createDefaultField(type, fieldType);
    }

    protected RichTextArea createRichTextArea() {
        RichTextArea rta = new RichTextArea();
        rta.setImmediate(true);
        return rta;
    }

    private <T extends Field> T createEnumField(Class<?> type, Class<T> fieldType) {
        Class<Object> selectClass = null;
        if (AbstractSelect.class.isAssignableFrom(fieldType)) {
            selectClass = fieldType;
        } else if (this.anySelect(fieldType)) {
            selectClass = AbstractSelect.class;
        }
        if (selectClass != null) {
            AbstractSelect s = this.createCompatibleSelect(selectClass);
            this.populateWithEnumData(s, type);
            return (T)s;
        }
        if (AbstractTextField.class.isAssignableFrom(fieldType)) {
            return this.createAbstractTextField(fieldType);
        }
        return null;
    }

    private <T extends Field> T createDateField(Class<?> type, Class<T> fieldType) {
        DateField field;
        if (InlineDateField.class.isAssignableFrom(fieldType)) {
            field = new InlineDateField();
        } else if (this.anyField(fieldType) || DateField.class.isAssignableFrom(fieldType)) {
            field = new PopupDateField();
        } else if (AbstractTextField.class.isAssignableFrom(fieldType)) {
            field = this.createAbstractTextField(fieldType);
        } else {
            return null;
        }
        field.setImmediate(true);
        return (T)field;
    }

    protected AbstractSelect createCompatibleSelect(Class<? extends AbstractSelect> fieldType) {
        AbstractSelect select;
        if (fieldType.isAssignableFrom(ListSelect.class)) {
            select = new ListSelect();
            select.setMultiSelect(false);
        } else if (fieldType.isAssignableFrom(NativeSelect.class)) {
            select = new NativeSelect();
        } else if (fieldType.isAssignableFrom(OptionGroup.class)) {
            select = new OptionGroup();
            select.setMultiSelect(false);
        } else if (fieldType.isAssignableFrom(Table.class)) {
            Table t = new Table();
            t.setSelectable(true);
            select = t;
        } else {
            select = new ComboBox(null);
        }
        select.setImmediate(true);
        select.setNullSelectionAllowed(false);
        return select;
    }

    protected boolean anyField(Class<?> fieldType) {
        return fieldType == Field.class || fieldType == AbstractField.class;
    }

    protected boolean anySelect(Class<? extends Field> fieldType) {
        return this.anyField(fieldType) || fieldType == AbstractSelect.class;
    }

    protected <T extends Field> T createBooleanField(Class<T> fieldType) {
        if (fieldType.isAssignableFrom(CheckBox.class)) {
            CheckBox cb = new CheckBox(null);
            cb.setImmediate(true);
            return (T)cb;
        }
        if (AbstractTextField.class.isAssignableFrom(fieldType)) {
            return this.createAbstractTextField(fieldType);
        }
        return null;
    }

    protected <T extends AbstractTextField> T createAbstractTextField(Class<T> fieldType) {
        if (fieldType == AbstractTextField.class) {
            fieldType = TextField.class;
        }
        try {
            AbstractTextField field = (AbstractTextField)fieldType.newInstance();
            field.setImmediate(true);
            return (T)field;
        }
        catch (Exception e) {
            throw new FieldGroup.BindException("Could not create a field of type " + fieldType, e);
        }
    }

    protected <T extends Field> T createDefaultField(Class<?> type, Class<T> fieldType) {
        if (fieldType.isAssignableFrom(TextField.class)) {
            return (T)((Field)fieldType.cast(this.createAbstractTextField(TextField.class)));
        }
        return null;
    }

    protected void populateWithEnumData(AbstractSelect select, Class<? extends Enum> enumClass) {
        select.removeAllItems();
        for (Object p : select.getContainerPropertyIds()) {
            select.removeContainerProperty(p);
        }
        select.addContainerProperty(CAPTION_PROPERTY_ID, String.class, "");
        select.setItemCaptionPropertyId(CAPTION_PROPERTY_ID);
        EnumSet<? extends Enum> enumSet = EnumSet.allOf(enumClass);
        for (Object e : enumSet) {
            Item newItem = select.addItem(e);
            newItem.getItemProperty(CAPTION_PROPERTY_ID).setValue(e.toString());
        }
    }
}

