/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.open;

import com.vaadin.open.App;
import com.vaadin.open.Docker;
import com.vaadin.open.FileUtil;
import com.vaadin.open.OSUtils;
import com.vaadin.open.Options;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Open {
    private static String wslMountPoint = null;

    static String getWslDrivesMountPoint() {
        if (wslMountPoint != null) {
            return wslMountPoint;
        }
        String defaultMountPoint = "/mnt/";
        String configFilePath = "/etc/wsl.conf";
        File configFile = new File(configFilePath);
        boolean isConfigFileExists = configFile.exists();
        if (!isConfigFileExists) {
            return defaultMountPoint;
        }
        try {
            String configContent = FileUtil.readFile(configFile);
            Pattern p = Pattern.compile("(?<!#.*)root\\s*=\\s*(?<mountPoint>.*)");
            Matcher matcher = p.matcher(configContent);
            if (!matcher.matches()) {
                return defaultMountPoint;
            }
            String mountPoint = matcher.group("mountPoint").trim();
            return mountPoint.endsWith("/") ? mountPoint : mountPoint + "/";
        }
        catch (IOException e) {
            e.printStackTrace();
            return defaultMountPoint;
        }
    }

    private static boolean doOpen(String target, String app, List<String> appArguments, Options options) {
        String command;
        ArrayList<String> cliArguments = new ArrayList<String>();
        boolean consumeOutput = false;
        if (OSUtils.isMac()) {
            command = "open";
            if (options.isWait()) {
                cliArguments.add("--wait-apps");
            }
            if (options.isBackground()) {
                cliArguments.add("--background");
            }
            if (options.isNewInstance()) {
                cliArguments.add("--new");
            }
            if (app != null) {
                cliArguments.add("-a");
                cliArguments.add(app);
            }
        } else if (OSUtils.isWindows() || OSUtils.isWsl() && !Docker.isDocker()) {
            boolean isWsl = OSUtils.isWsl();
            String mountPoint = Open.getWslDrivesMountPoint();
            command = isWsl ? mountPoint + "c/Windows/System32/WindowsPowerShell/v1.0/powershell.exe" : System.getenv("SYSTEMROOT") + "\\System32\\WindowsPowerShell\\v1.0\\powershell";
            cliArguments.addAll(Arrays.asList("-NoProfile", "-NonInteractive", "\u2013ExecutionPolicy", "Bypass", "-EncodedCommand"));
            ArrayList<String> encodedArguments = new ArrayList<String>();
            encodedArguments.add("Start");
            if (options.isWait()) {
                encodedArguments.add("-Wait");
            }
            if (app != null) {
                encodedArguments.add("\"`\"" + app + "`\"\"");
                encodedArguments.add("-ArgumentList");
                if (target != null) {
                    appArguments.add(0, target);
                }
            } else if (target != null) {
                encodedArguments.add("\"" + target + "\"");
            }
            if (!appArguments.isEmpty()) {
                String joinedArgs = appArguments.stream().map(arg -> "\"`\"" + arg + "`\"\"").collect(Collectors.joining(","));
                encodedArguments.add(joinedArgs);
            }
            target = Base64.getEncoder().encodeToString(encodedArguments.stream().collect(Collectors.joining(" ")).getBytes(StandardCharsets.UTF_16LE));
        } else {
            if (app != null) {
                command = app;
            } else {
                command = "xdg-open";
                InputStream bundledXdgOpen = Open.class.getResourceAsStream("xdg-open");
                try {
                    File open = File.createTempFile("xdg", "open");
                    open.setExecutable(true);
                    open.deleteOnExit();
                    try (FileOutputStream out = new FileOutputStream(open);){
                        FileUtil.copy(bundledXdgOpen, out);
                        command = open.getAbsolutePath();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!appArguments.isEmpty()) {
                cliArguments.addAll(appArguments);
            }
            if (!options.isWait()) {
                consumeOutput = true;
            }
        }
        if (target != null) {
            cliArguments.add(target);
        }
        if (OSUtils.isMac() && appArguments.size() > 0) {
            cliArguments.add("--args");
            cliArguments.addAll(appArguments);
        }
        cliArguments.add(0, command);
        try {
            Process subprocess = new ProcessBuilder(new String[0]).command(cliArguments).start();
            if (options.isWait()) {
                try {
                    int exitCode = subprocess.waitFor();
                    if (!options.isAllowNonzeroExitCode() && exitCode > 0) {
                        return false;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            if (consumeOutput) {
                FileUtil.read(subprocess.getInputStream());
            }
            for (int i = 0; i < 5; ++i) {
                if (!subprocess.isAlive() && subprocess.exitValue() != 0) {
                    return false;
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean open(String target) {
        return Open.open(target, new Options());
    }

    public static boolean open(String target, Options options) {
        return Open.doOpen(target, null, new ArrayList<String>(), options);
    }

    public static boolean open(String target, App app) {
        return Open.open(target, app, new Options());
    }

    public static boolean open(String target, App app, Options options) {
        for (String name : app.getApp()) {
            if (!Open.doOpen(target, name, new ArrayList<String>(), options)) continue;
            return true;
        }
        return false;
    }

    public static boolean openApp(String name, List<String> appArguments, Options options) {
        return Open.doOpen(null, name, appArguments, options);
    }

    public static boolean openApp(App app, List<String> appArguments, Options options) {
        for (String name : app.getApp()) {
            if (!Open.doOpen(null, name, appArguments, options)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            String appId = args[1].toUpperCase(Locale.ENGLISH);
            App app = App.valueOf(appId);
            Open.open(args[0], app, new Options());
        } else {
            Open.open(args[0], new Options());
        }
    }
}

