/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.communication.TransferUtil;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ServletResourceDownloadHandler
extends AbstractDownloadHandler<ServletResourceDownloadHandler> {
    private final String path;
    private final String fileNameOverride;

    public ServletResourceDownloadHandler(String path) {
        this(path, null);
    }

    public ServletResourceDownloadHandler(String path, String fileNameOverride) {
        this.path = path;
        this.fileNameOverride = fileNameOverride;
    }

    @Override
    public void handleDownloadRequest(DownloadEvent downloadEvent) throws IOException {
        this.setTransferUI(downloadEvent.getUI());
        VaadinService service = downloadEvent.getRequest().getService();
        VaadinResponse response = downloadEvent.getResponse();
        if (service instanceof VaadinServletService) {
            VaadinServletService servletService = (VaadinServletService)service;
            try (OutputStream outputStream = downloadEvent.getOutputStream();
                 InputStream inputStream = servletService.getServlet().getServletContext().getResourceAsStream(this.path);){
                String resourceName = this.getUrlPostfix();
                downloadEvent.setContentType(this.getContentType(resourceName, response));
                if (this.isInline()) {
                    downloadEvent.inline(resourceName);
                } else {
                    downloadEvent.setFileName(resourceName);
                }
                TransferUtil.transfer(inputStream, outputStream, this.getTransferContext(downloadEvent), this.getListeners());
            }
            catch (IOException ioe) {
                response.setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
                downloadEvent.setException(ioe);
                this.notifyError(downloadEvent, ioe);
                throw ioe;
            }
        }
    }

    @Override
    public String getUrlPostfix() {
        if (this.fileNameOverride != null) {
            return this.fileNameOverride;
        }
        if (this.path.contains("/")) {
            return this.path.substring(this.path.lastIndexOf(47) + 1);
        }
        return this.path;
    }
}

