/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FrontendVersion;
import elemental.json.Json;
import elemental.json.JsonObject;
import org.slf4j.LoggerFactory;

class VersionsJsonFilter {
    private final JsonObject userManagedDependencies;
    private final JsonObject vaadinVersions;
    private final String dependenciesKey;
    private final String OLDER_VERSION_WARNING = "Using user pinned version '{}' of '{}' which is older than the current platform version '{}'";

    VersionsJsonFilter(JsonObject packageJson, String dependenciesKey) {
        this.dependenciesKey = dependenciesKey;
        this.userManagedDependencies = this.collectUserManagedDependencies(packageJson);
        this.vaadinVersions = this.collectFrameworkVersions(packageJson);
    }

    JsonObject getFilteredVersions(JsonObject versions) {
        JsonObject json = Json.createObject();
        for (String key : versions.keys()) {
            if (this.userManagedDependencies.hasKey(key)) {
                if (this.isNewer(versions.getString(key), this.userManagedDependencies.getString(key))) {
                    LoggerFactory.getLogger((String)"Versions").warn("Using user pinned version '{}' of '{}' which is older than the current platform version '{}'", new Object[]{this.userManagedDependencies.getString(key), key, versions.getString(key)});
                }
                json.put(key, this.userManagedDependencies.getString(key));
                continue;
            }
            if (this.vaadinVersions.hasKey(key) && this.isNewer(this.vaadinVersions.getString(key), versions.getString(key))) {
                json.put(key, this.vaadinVersions.getString(key));
                continue;
            }
            json.put(key, versions.getString(key));
        }
        return json;
    }

    private boolean isNewer(String version1, String version2) {
        FrontendVersion frontendVersion = new FrontendVersion(version1);
        FrontendVersion frontendVersion2 = new FrontendVersion(version2);
        return frontendVersion.isNewerThan(frontendVersion2);
    }

    private JsonObject collectUserManagedDependencies(JsonObject packageJson) {
        JsonObject json = Json.createObject();
        JsonObject vaadinDep = this.collectFrameworkVersions(packageJson);
        if (packageJson.hasKey(this.dependenciesKey)) {
            JsonObject dependencies = packageJson.getObject(this.dependenciesKey);
            for (String key : dependencies.keys()) {
                if (!this.isUserChanged(key, vaadinDep, dependencies)) continue;
                json.put(key, dependencies.getString(key));
            }
        }
        return json;
    }

    private boolean isUserChanged(String key, JsonObject vaadinDep, JsonObject dependencies) {
        if (vaadinDep.hasKey(key)) {
            FrontendVersion dep;
            FrontendVersion vaadin = new FrontendVersion(vaadinDep.getString(key));
            return !vaadin.isEqualTo(dep = new FrontendVersion(dependencies.getString(key)));
        }
        return true;
    }

    private JsonObject collectFrameworkVersions(JsonObject packageJson) {
        if (packageJson.hasKey("vaadin") && packageJson.getObject("vaadin").hasKey(this.dependenciesKey)) {
            return packageJson.getObject("vaadin").getObject(this.dependenciesKey);
        }
        return Json.createObject();
    }
}

