/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import com.vaadin.flow.server.communication.rpc.AbstractRpcInvocationHandler;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnChannelHandler
extends AbstractRpcInvocationHandler {
    @Override
    public String getRpcType() {
        return "channel";
    }

    @Override
    protected Optional<Runnable> handleNode(StateNode node, JsonObject invocationJson) {
        int channelId = (int)invocationJson.getNumber("channel");
        JsonArray arguments = invocationJson.getArray("args");
        if (!node.hasFeature(ReturnChannelMap.class)) {
            ReturnChannelHandler.getLogger().warn("Node has no return channels: {}", (Object)invocationJson);
            return Optional.empty();
        }
        ReturnChannelRegistration channel = node.getFeatureIfInitialized(ReturnChannelMap.class).map(map -> map.get(channelId)).orElse(null);
        if (channel == null) {
            ReturnChannelHandler.getLogger().warn("Return channel not found: {}", (Object)invocationJson);
            return Optional.empty();
        }
        if (!node.isEnabled() && channel.getDisabledUpdateMode() != DisabledUpdateMode.ALWAYS) {
            ReturnChannelHandler.getLogger().warn("Ignoring update for disabled return channel: {}", (Object)invocationJson);
            return Optional.empty();
        }
        channel.invoke(arguments);
        return Optional.empty();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ReturnChannelHandler.class.getName());
    }
}

