/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.ICBORToFromConverter;
import com.upokecenter.cbor.URIUtility;
import java.net.URI;

class CBORUriConverter
implements ICBORToFromConverter<URI> {
    CBORUriConverter() {
    }

    private CBORObject ValidateObject(CBORObject obj) {
        if (obj.getType() != CBORType.TextString) {
            throw new CBORException("URI/IRI must be a text String");
        }
        boolean isiri = obj.HasMostOuterTag(266);
        boolean isiriref = obj.HasMostOuterTag(267);
        if (isiriref && !URIUtility.IsValidIRI(obj.AsString(), URIUtility.ParseMode.IRIStrict)) {
            throw new CBORException("String is not a valid IRI Reference");
        }
        if (!(!isiri || URIUtility.IsValidIRI(obj.AsString(), URIUtility.ParseMode.IRIStrict) && URIUtility.HasScheme(obj.AsString()))) {
            throw new CBORException("String is not a valid IRI");
        }
        if (!URIUtility.IsValidIRI(obj.AsString(), URIUtility.ParseMode.URIStrict) || !URIUtility.HasScheme(obj.AsString())) {
            throw new CBORException("String is not a valid URI");
        }
        return obj;
    }

    @Override
    public URI FromCBORObject(CBORObject obj) {
        if (obj.HasMostOuterTag(32) || obj.HasMostOuterTag(266) || obj.HasMostOuterTag(267)) {
            this.ValidateObject(obj);
            try {
                return new URI(obj.AsString());
            }
            catch (Exception ex) {
                throw new CBORException(ex.getMessage(), ex);
            }
        }
        throw new CBORException();
    }

    @Override
    public CBORObject ToCBORObject(URI uri) {
        int tag;
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        String uriString = uri.toString();
        boolean nonascii = false;
        for (int i = 0; i < uriString.length(); ++i) {
            nonascii |= uriString.charAt(i) >= '\u0080';
        }
        int n = tag = nonascii ? 266 : 32;
        if (!URIUtility.HasScheme(uriString)) {
            tag = 267;
        }
        return CBORObject.FromObjectAndTag((Object)uriString, tag);
    }
}

