/*
 * Decompiled with CFR 0.152.
 */
package com.staros.schedule;

import com.google.common.collect.ImmutableMap;
import com.staros.proto.PlacementPolicy;
import com.staros.schedule.select.Selector;
import com.staros.worker.Worker;
import com.staros.worker.WorkerManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScheduleScorer {
    private static final long workerShardNumberWeight = 1L;
    private static final long shardGroupPackWeight = 10000L;
    private static final long shardGroupSpreadWeight = -100L;
    private static final Map<PlacementPolicy, Long> shardGroupWeight = ImmutableMap.builder().put((Object)PlacementPolicy.PACK, (Object)10000L).put((Object)PlacementPolicy.SPREAD, (Object)-100L).build();
    private final Map<Long, Double> scores;

    public ScheduleScorer(Collection<Long> targetWorkers) {
        this.scores = new HashMap<Long, Double>(targetWorkers.size());
        targetWorkers.forEach(x -> this.scores.put((Long)x, 0.0));
    }

    public void apply(WorkerManager manager) {
        this.scores.replaceAll((id, val) -> {
            Worker worker = manager.getWorker((long)id);
            return worker == null ? val : val - Math.log(worker.getNumOfShards() * 1L + 1L);
        });
    }

    public void apply(PlacementPolicy policy, Collection<Long> workerIds) {
        if (!shardGroupWeight.containsKey(policy)) {
            return;
        }
        long weight = shardGroupWeight.get(policy);
        workerIds.forEach(key -> this.scores.computeIfPresent((Long)key, (k, val) -> val + (double)weight));
    }

    public boolean isEmpty() {
        return this.scores.isEmpty();
    }

    public void remove(long workerId) {
        this.scores.remove(workerId);
    }

    public Map<Long, Double> getScores() {
        return Collections.unmodifiableMap(this.scores);
    }

    public List<Long> selectHighEnd(Selector selector, int nSelect) {
        return selector.selectHighEnd(this.scores, nSelect);
    }

    public List<Long> selectLowEnd(Selector selector, int nSelect) {
        return selector.selectLowEnd(this.scores, nSelect);
    }
}

