/*
 * Decompiled with CFR 0.152.
 */
package com.staros.schedule;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.staros.shard.Shard;
import com.staros.shard.ShardGroup;
import com.staros.shard.ShardManager;
import com.staros.worker.Worker;
import com.staros.worker.WorkerManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ReplicaWorkerInvertIndex {
    private final Multimap<Long, Long> workerIndex = ArrayListMultimap.create();
    private final Set<Long> workerGroupIds = new HashSet<Long>();

    private void addReplica(long shardId, Worker worker) {
        if (worker == null) {
            return;
        }
        this.workerGroupIds.add(worker.getGroupId());
        this.workerIndex.put((Object)worker.getWorkerId(), (Object)shardId);
    }

    public void buildFrom(WorkerManager workerManager, ShardManager shardManager, ShardGroup group) {
        for (long id : group.getShardIds()) {
            Shard shard = shardManager.getShard(id);
            if (shard == null) continue;
            this.addReplicas(workerManager, shard);
        }
    }

    public void addReplicas(WorkerManager workerManager, Shard shard) {
        shard.getReplicaWorkerIds().forEach(x -> this.addReplica(shard.getShardId(), workerManager.getWorker((long)x)));
    }

    public void addReplica(long shardId, long workerId, long workerGroupId) {
        this.workerGroupIds.add(workerGroupId);
        this.workerIndex.put((Object)workerId, (Object)shardId);
    }

    public void removeReplica(long shardId, long workerId) {
        this.workerIndex.remove((Object)workerId, (Object)shardId);
    }

    public Collection<Long> getReplicaShardList(long workerId) {
        if (this.workerIndex.containsKey((Object)workerId)) {
            return this.workerIndex.get((Object)workerId);
        }
        return Collections.emptyList();
    }

    public Collection<Long> getAllWorkerGroupIds() {
        return this.workerGroupIds;
    }
}

