/*
 * Decompiled with CFR 0.152.
 */
package com.staros.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.staros.exception.ExceptionCode;
import com.staros.exception.NotImplementedStarException;
import com.staros.exception.StarException;
import com.staros.manager.HttpDispatcher;
import com.staros.manager.StarManager;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpService {
    public static final Logger LOG = LogManager.getLogger(HttpService.class);
    private HttpDispatcher httpDispatcher;

    public HttpService(StarManager manager) {
        this.httpDispatcher = new HttpDispatcher(manager);
    }

    public HttpResponse starmgrHttpService(HttpRequest request) {
        HttpResponseStatus status = HttpResponseStatus.OK;
        Object object = null;
        try {
            object = this.httpDispatcher.getObject(request.uri());
        }
        catch (StarException e) {
            status = e.getExceptionCode() == ExceptionCode.INVALID_ARGUMENT ? HttpResponseStatus.BAD_REQUEST : (e.getExceptionCode() == ExceptionCode.NOT_EXIST ? HttpResponseStatus.NOT_FOUND : HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return HttpService.createResponse(object, request, status);
    }

    public static HttpResponse createResponse(Object object, HttpRequest request, HttpResponseStatus status) {
        AsciiString contentType = HttpHeaderValues.APPLICATION_JSON;
        try {
            contentType = HttpService.getContentTypeFromHeader(request);
        }
        catch (NotImplementedStarException e) {
            status = HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE;
        }
        if (object == null) {
            return HttpService.createEmptyResponse(contentType, status);
        }
        String content = "";
        try {
            content = contentType == HttpHeaderValues.APPLICATION_JSON ? HttpService.serializeToJson(object) : HttpService.serializeToText(object);
        }
        catch (Exception e) {
            content = "Error serializing object: " + e.getMessage();
            status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        }
        return HttpService.createResponse(content, contentType, status);
    }

    public static AsciiString getContentTypeFromHeader(HttpRequest request) throws StarException {
        String acceptHeader = request.headers().get((CharSequence)HttpHeaderNames.ACCEPT);
        if (acceptHeader != null) {
            if ((acceptHeader = acceptHeader.toLowerCase()).contains("application/json") || acceptHeader.contains("*/*")) {
                return HttpHeaderValues.APPLICATION_JSON;
            }
            if (acceptHeader.contains("text/plain")) {
                return HttpHeaderValues.TEXT_PLAIN;
            }
            throw new NotImplementedStarException("Unsupported Accept header value");
        }
        return HttpHeaderValues.APPLICATION_JSON;
    }

    public static HttpResponse createEmptyResponse(AsciiString contentType, HttpResponseStatus status) {
        String content = contentType == HttpHeaderValues.APPLICATION_JSON ? "{}" : "";
        return HttpService.createResponse(content, contentType, status);
    }

    public static HttpResponse createResponse(String content, AsciiString contentType, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        return response;
    }

    public static String serializeToJson(Object object) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        if (object instanceof List) {
            List objectList = (List)object;
            for (Object item : objectList) {
                String jsonString = JsonFormat.printer().includingDefaultValueFields().print((MessageOrBuilder)((Message)item));
                arrayNode.add(mapper.readTree(jsonString));
            }
        } else {
            String jsonString = JsonFormat.printer().includingDefaultValueFields().print((MessageOrBuilder)((Message)object));
            arrayNode.add(mapper.readTree(jsonString));
        }
        return arrayNode.toString();
    }

    public static String serializeToText(Object object) throws Exception {
        StringBuilder contentBuilder = new StringBuilder();
        if (object instanceof List) {
            List objectList = (List)object;
            for (Object item : objectList) {
                contentBuilder.append(item.toString());
            }
        } else {
            contentBuilder.append(object.toString());
        }
        return contentBuilder.toString();
    }
}

