/*
 * Decompiled with CFR 0.152.
 */
package com.staros.manager;

import com.staros.exception.InvalidArgumentStarException;
import com.staros.exception.NotExistStarException;
import com.staros.exception.StarException;
import com.staros.manager.StarManager;
import com.staros.proto.ShardGroupInfo;
import com.staros.proto.ShardInfo;
import com.staros.proto.WorkerGroupDetailInfo;
import com.staros.proto.WorkerInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpDispatcher {
    public static final Logger LOG = LogManager.getLogger(HttpDispatcher.class);
    private StarManager starManager;
    private List<Pair<Pattern, Function<Matcher, Object>>> routeList = new ArrayList<Pair<Pattern, Function<Matcher, Object>>>();
    private static final String SERVICE = "SERVICE";
    private static final String ID = "ID";
    private static final String SHARD_PATTERN = ".*/service/(?<SERVICE>.*?)/shard/(?<ID>[^/]*)";
    private static final String SHARDGROUP_PATTERN = ".*/service/(?<SERVICE>.*?)/shardgroup/(?<ID>[^/]*)";
    private static final String LIST_SHARDGROUP_PATTERN = ".*/service/(?<SERVICE>.*?)/listshardgroup";
    private static final String REMOVE_SHARDGROUP_REPLICAS_PATTERN = ".*/service/(?<SERVICE>.*?)/shardgroup/(?<ID>.*?)/removereplicas";
    private static final String WORKER_PATTERN = ".*/service/(?<SERVICE>.*?)/worker/(?<ID>[^/]*)";
    private static final String WORKERGROUP_PATTERN = ".*/service/(?<SERVICE>.*?)/workergroup/(?<ID>[^/]*)";
    private static final String LIST_WORKERGROUP_PATTERN = ".*/service/(?<SERVICE>.*?)/listworkergroup";

    public HttpDispatcher(StarManager manager) {
        this.routeList.add((Pair<Pattern, Function<Matcher, Object>>)Pair.of((Object)Pattern.compile(SHARD_PATTERN, 2), this::getShardInfoHandler));
        this.routeList.add((Pair<Pattern, Function<Matcher, Object>>)Pair.of((Object)Pattern.compile(SHARDGROUP_PATTERN, 2), this::getShardGroupInfoHandler));
        this.routeList.add((Pair<Pattern, Function<Matcher, Object>>)Pair.of((Object)Pattern.compile(LIST_SHARDGROUP_PATTERN, 2), this::listShardGroupInfoHandler));
        this.routeList.add((Pair<Pattern, Function<Matcher, Object>>)Pair.of((Object)Pattern.compile(REMOVE_SHARDGROUP_REPLICAS_PATTERN, 2), this::removeShardGroupReplicasHandler));
        this.routeList.add((Pair<Pattern, Function<Matcher, Object>>)Pair.of((Object)Pattern.compile(WORKER_PATTERN, 2), this::getWorkerInfoHandler));
        this.routeList.add((Pair<Pattern, Function<Matcher, Object>>)Pair.of((Object)Pattern.compile(WORKERGROUP_PATTERN, 2), this::getWorkerGroupInfoHandler));
        this.routeList.add((Pair<Pattern, Function<Matcher, Object>>)Pair.of((Object)Pattern.compile(LIST_WORKERGROUP_PATTERN, 2), this::listWorkerGroupInfoHandler));
        this.starManager = manager;
    }

    Object getObject(String path) throws StarException {
        for (Pair<Pattern, Function<Matcher, Object>> pair : this.routeList) {
            Matcher matcher = ((Pattern)pair.getKey()).matcher(path);
            if (!matcher.matches()) continue;
            Function handler = (Function)pair.getValue();
            return handler.apply(matcher);
        }
        throw new NotExistStarException("No matching pattern found");
    }

    public Object getShardInfoHandler(Matcher matcher) throws StarException {
        Long id;
        String service = matcher.group(SERVICE);
        String shardId = matcher.group(ID);
        try {
            id = Long.valueOf(shardId);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentStarException("Shard id: {} is not a long type number", new Object[]{shardId});
        }
        String serviceId = this.starManager.getServiceIdByIdOrName(service);
        List<ShardInfo> shardInfoList = this.starManager.getShardInfo(serviceId, Collections.singletonList(id), 0L);
        return shardInfoList;
    }

    public Object getShardGroupInfoHandler(Matcher matcher) throws StarException {
        Long id;
        String service = matcher.group(SERVICE);
        String shardGroupId = matcher.group(ID);
        try {
            id = Long.valueOf(shardGroupId);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentStarException("Shard group id: {} is not a long type number", new Object[]{shardGroupId});
        }
        String serviceId = this.starManager.getServiceIdByIdOrName(service);
        List<ShardGroupInfo> shardGroupInfoList = this.starManager.getShardGroupInfo(serviceId, Collections.singletonList(id));
        return shardGroupInfoList;
    }

    public Object listShardGroupInfoHandler(Matcher matcher) throws StarException {
        String service = matcher.group(SERVICE);
        String serviceId = this.starManager.getServiceIdByIdOrName(service);
        List shardGroupInfoList = (List)this.starManager.listShardGroupInfo(serviceId, true, 0L).getKey();
        return shardGroupInfoList;
    }

    public Object removeShardGroupReplicasHandler(Matcher matcher) throws StarException {
        Long id;
        String service = matcher.group(SERVICE);
        String shardGroupId = matcher.group(ID);
        try {
            id = Long.valueOf(shardGroupId);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentStarException("Shard group id: {} is not a long type number", new Object[]{shardGroupId});
        }
        String serviceId = this.starManager.getServiceIdByIdOrName(service);
        this.starManager.removeShardGroupReplicas(serviceId, id);
        return null;
    }

    public Object getWorkerInfoHandler(Matcher matcher) throws StarException {
        Long id;
        String service = matcher.group(SERVICE);
        String workerId = matcher.group(ID);
        try {
            id = Long.valueOf(workerId);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentStarException("Worker id: {} is not a long type number", new Object[]{workerId});
        }
        String serviceId = this.starManager.getServiceIdByIdOrName(service);
        WorkerInfo workerInfo = this.starManager.getWorkerInfo(serviceId, id);
        return workerInfo;
    }

    public Object getWorkerGroupInfoHandler(Matcher matcher) throws StarException {
        Long id;
        String service = matcher.group(SERVICE);
        String workerGroupId = matcher.group(ID);
        try {
            id = Long.valueOf(workerGroupId);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentStarException("Worker group id: {} is not a long type number", new Object[]{workerGroupId});
        }
        String serviceId = this.starManager.getServiceIdByIdOrName(service);
        List<WorkerGroupDetailInfo> workerGroupList = this.starManager.listWorkerGroups(serviceId, Collections.singletonList(id), Collections.emptyMap(), true);
        return workerGroupList;
    }

    public Object listWorkerGroupInfoHandler(Matcher matcher) throws StarException {
        String service = matcher.group(SERVICE);
        String serviceId = this.starManager.getServiceIdByIdOrName(service);
        List<WorkerGroupDetailInfo> workerGroupList = this.starManager.listWorkerGroups(serviceId, Collections.emptyList(), Collections.emptyMap(), true);
        return workerGroupList;
    }
}

