/*
 * Decompiled with CFR 0.152.
 */
package com.staros.stream;

import com.google.protobuf.CodedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends FilterOutputStream {
    private boolean closed = false;

    public ChunkedOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] data = new byte[]{(byte)b};
        this.write(data, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.writeIntInternal(len);
        this.out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.writeIntInternal(0);
        this.out.flush();
        this.closed = true;
    }

    private void writeIntInternal(int n) throws IOException {
        int len = CodedOutputStream.computeUInt32SizeNoTag((int)n);
        byte[] varintBytes = new byte[len];
        CodedOutputStream os = CodedOutputStream.newInstance((byte[])varintBytes);
        os.writeUInt32NoTag(n);
        os.flush();
        this.out.write(varintBytes, 0, varintBytes.length);
    }
}

